/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import java.net.URI;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.http.CouchMethodType;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.CouchResponse;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponse;

public class WriteResponse
implements CouchResponse {
    private final URI uri;
    private final CouchHttpStatus httpStatus;
    private final CouchMethodType methodType;
    private final CouchMediaType contentType;
    private final String documentId;
    private final String documentRevision;
    private final String content;

    public WriteResponse(CouchHttpResponse couchHttpResponse) {
        this.uri = couchHttpResponse.getUri();
        this.methodType = couchHttpResponse.getMethodType();
        this.httpStatus = couchHttpResponse.getHttpStatus();
        this.contentType = couchHttpResponse.getContentType();
        this.documentId = couchHttpResponse.getDocumentId();
        this.documentRevision = couchHttpResponse.getEtag();
        this.content = couchHttpResponse.getStringContent();
    }

    public WriteResponse(CouchMethodType methodType, URI uri, CouchHttpStatus httpStatus, CouchMediaType contentType, String documentId, String documentRevision, String content) {
        ArgUtil.assertNotNull((Object)methodType, "HttpMethodType");
        ArgUtil.assertNotNull(uri, "URI");
        ArgUtil.assertNotNull((Object)httpStatus, "HttpStatus");
        this.uri = uri;
        this.methodType = methodType;
        this.httpStatus = httpStatus;
        this.contentType = contentType;
        this.documentId = documentId;
        this.documentRevision = documentRevision;
        this.content = content;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentRevision() {
        return this.documentRevision;
    }

    public boolean hasDocumentRevision() {
        return this.documentRevision != null;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public CouchMethodType getMethodType() {
        return this.methodType;
    }

    @Override
    public CouchHttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public int getHttpStatusCode() {
        return this.httpStatus.getCode();
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public CouchMediaType getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isOk() {
        return this.httpStatus.isOk();
    }

    @Override
    public boolean isNotFound() {
        return this.httpStatus.isNotFound();
    }

    @Override
    public boolean isCreated() {
        return this.httpStatus.isCreated();
    }

    @Override
    public boolean isConflict() {
        return this.httpStatus.isConflict();
    }

    @Override
    public boolean isUnauthorized() {
        return this.httpStatus.isUnauthorized();
    }

    @Override
    public boolean isSuccess() {
        return this.httpStatus == CouchHttpStatus.CREATED || this.httpStatus == CouchHttpStatus.OK;
    }

    @Override
    public boolean isError() {
        return this.httpStatus != CouchHttpStatus.CREATED && this.httpStatus != CouchHttpStatus.OK;
    }

    @Override
    public CouchErrorContent getErrorContent() {
        return CouchErrorContent.parseJson(this.getContent());
    }

    @Override
    public String getErrorReason() {
        return this.getErrorContent().getReason();
    }
}

