/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.tiogasolutions.notify.engine.AppResource;
import org.tiogasolutions.notify.engine.v1.AdminResourceV1;
import org.tiogasolutions.notify.engine.v1.ClientResourceV1;
import org.tiogasolutions.notify.engine.web.SystemStatus;
import org.tiogasolutions.notify.engine.web.readers.StaticContentReader;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.receiver.ReceiverExecutor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorExecutor;

@Path(value="/")
@Scope(value="prototype")
public class RootResource {
    private static final Logger log = LoggerFactory.getLogger(RootResource.class);
    @Context
    UriInfo uriInfo;
    @Autowired
    private DomainKernel domainKernel;
    @Autowired
    private ExecutionManager executionManager;
    @Autowired
    private NotificationKernel notificationKernel;
    @Autowired
    private ReceiverExecutor receiverExecutor;
    @Autowired
    private TaskProcessorExecutor processorExecutor;
    @Autowired
    private EventBus eventBus;
    @Autowired
    private StaticContentReader staticContentReader;

    @GET
    @Produces(value={"text/html"})
    public Response getDefaultPage() throws Exception {
        URI uri = this.uriInfo.getBaseUriBuilder().path("/app").build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }

    @Path(value="/app")
    public AppResource getAppResource() {
        return new AppResource(this.staticContentReader, this.uriInfo);
    }

    @Path(value="/api/v1/client")
    public ClientResourceV1 getClientResource() {
        return new ClientResourceV1(this.executionManager, this.domainKernel, this.notificationKernel, this.eventBus);
    }

    @Path(value="/api/v1/admin")
    public AdminResourceV1 getAdminResource() {
        return new AdminResourceV1(this.executionManager, this.domainKernel, this.notificationKernel, this.receiverExecutor, this.processorExecutor, this.eventBus);
    }

    @GET
    @Path(value="/api/v1/status")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public SystemStatus getStatus() {
        return new SystemStatus(this.receiverExecutor.getExecutorStatus(), this.processorExecutor.getExecutorStatus());
    }
}

