/*
 * Decompiled with CFR 0.152.
 */
package org.unbescape.csv;

import java.io.IOException;
import java.io.Writer;
import org.unbescape.csv.CsvEscapeUtil;

public final class CsvEscape {
    public static String escapeCsv(String text) {
        return CsvEscapeUtil.escape(text);
    }

    public static void escapeCsv(char[] text, int offset, int len, Writer writer) throws IOException {
        int textLen;
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'writer' cannot be null");
        }
        int n = textLen = text == null ? 0 : text.length;
        if (offset < 0 || offset > textLen) {
            throw new IllegalArgumentException("Invalid (offset, len). offset=" + offset + ", len=" + len + ", text.length=" + textLen);
        }
        if (len < 0 || offset + len > textLen) {
            throw new IllegalArgumentException("Invalid (offset, len). offset=" + offset + ", len=" + len + ", text.length=" + textLen);
        }
        CsvEscapeUtil.escape(text, offset, len, writer);
    }

    public static String unescapeCsv(String text) {
        return CsvEscapeUtil.unescape(text);
    }

    public static void unescapeCsv(char[] text, int offset, int len, Writer writer) throws IOException {
        int textLen;
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'writer' cannot be null");
        }
        int n = textLen = text == null ? 0 : text.length;
        if (offset < 0 || offset > textLen) {
            throw new IllegalArgumentException("Invalid (offset, len). offset=" + offset + ", len=" + len + ", text.length=" + textLen);
        }
        if (len < 0 || offset + len > textLen) {
            throw new IllegalArgumentException("Invalid (offset, len). offset=" + offset + ", len=" + len + ", text.length=" + textLen);
        }
        CsvEscapeUtil.unescape(text, offset, len, writer);
    }

    private CsvEscape() {
    }
}

