/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PubLink {
    private final String href;
    private final String rel;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, String> docs = new LinkedHashMap<String, String>();

    @JsonCreator
    private PubLink(@JsonProperty(value="rel") String rel, @JsonProperty(value="href") String href, @JsonProperty(value="docs") Map<String, String> docs) {
        this.rel = rel;
        this.href = href;
        if (docs != null) {
            this.docs.putAll(docs);
        }
    }

    public String getHref() {
        return this.href;
    }

    public String getRel() {
        return this.rel;
    }

    public Map<String, String> getDocs() {
        return Collections.unmodifiableMap(this.docs);
    }

    public PubLink clone(String rel) {
        return new PubLink(rel, this.href, this.docs);
    }

    public PubLink toSelf() {
        return this.clone("self");
    }

    public PubLink toFirst() {
        return this.clone("first");
    }

    public PubLink toPrev() {
        return this.clone("prev");
    }

    public PubLink toNext() {
        return this.clone("next");
    }

    public PubLink toLast() {
        return this.clone("last");
    }

    public String toString() {
        return this.rel + ": " + this.href;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PubLink pubLink = (PubLink)o;
        if (this.href != null ? !this.href.equals(pubLink.href) : pubLink.href != null) {
            return false;
        }
        return this.rel != null ? this.rel.equals(pubLink.rel) : pubLink.rel == null;
    }

    public int hashCode() {
        int result = this.href != null ? this.href.hashCode() : 0;
        result = 31 * result + (this.rel != null ? this.rel.hashCode() : 0);
        return result;
    }

    public PubLink toLinks() {
        return this.clone(this.rel + "-links");
    }

    public PubLink toItems() {
        return this.clone(this.rel + "-items");
    }

    public static PubLink create(String rel, String href) {
        return PubLink.create(rel, href, new String[0]);
    }

    public static PubLink create(String rel, String href, String ... docItems) {
        PubLink link = new PubLink(rel, href, Collections.emptyMap());
        for (String doc : docItems) {
            int pos = doc.indexOf(":");
            if (pos < 0) {
                throw new IllegalArgumentException("Invalid docs: " + doc);
            }
            String key = doc.substring(0, pos).trim().toUpperCase();
            String val = doc.substring(pos + 1).trim();
            link.docs.put(key, val);
        }
        return link;
    }
}

