/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.pub.PubLink;

public class PubLinks
extends LinkedHashMap<String, PubLink> {
    @JsonCreator
    private PubLinks(Map<String, PubLink> links) {
        for (PubLink link : links.values()) {
            this.put(link.getRel(), link);
        }
    }

    @JsonIgnore
    public List<PubLink> getItems() {
        return new ArrayList<PubLink>(this.values());
    }

    public PubLink getLink(String rel) {
        return (PubLink)this.get(rel);
    }

    public boolean hasLink(String rel) {
        return this.getLink(rel) != null;
    }

    public PubLink add(String rel, String href) {
        return this.add(PubLink.create(rel, href));
    }

    public PubLink add(PubLink link) {
        if (link != null) {
            return this.put(link.getRel(), link);
        }
        return null;
    }

    public void addAll(Collection<PubLink> links) {
        links.forEach(this::add);
    }

    public void addFPNL(PubLink firstLink, PubLink prevLink, PubLink nextLink, PubLink lastLink) {
        this.add(firstLink.clone("first"));
        this.add(prevLink.clone("prev"));
        this.add(nextLink.clone("next"));
        this.add(lastLink.clone("last"));
    }

    public static PubLinks empty() {
        return new PubLinks(Collections.emptyMap());
    }

    public static PubLinks self(PubLink ... items) {
        return PubLinks.self(Arrays.asList(items));
    }

    public static PubLinks self(List<PubLink> items) {
        PubLinks links = new PubLinks(Collections.emptyMap());
        for (PubLink link : items) {
            if (link.getRel().endsWith("-links")) {
                links.add(link.clone("self-links"));
                continue;
            }
            if (link.getRel().endsWith("-items")) {
                links.add(link.clone("self-items"));
                continue;
            }
            links.add(link.clone("self"));
        }
        return links;
    }
}

