/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.web;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.notify.kernel.admin.AdminKernel;
import org.tiogasolutions.notify.kernel.config.SystemConfiguration;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.pub.domain.DomainProfile;

@Provider
@PreMatching
@Priority(value=2000)
public class EngineRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(EngineRequestFilter.class);
    @Context
    private UriInfo uriInfo;
    @Context
    Application application;
    @Context
    private HttpHeaders headers;
    @Autowired
    private ExecutionManager executionManager;
    @Autowired
    private DomainKernel domainKernel;
    @Autowired
    private AdminKernel adminKernel;
    @Autowired
    private SystemConfiguration systemConfiguration;

    public EngineRequestFilter() {
        log.info("Created");
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String baseUri = this.uriInfo.getBaseUri().toString();
        String requestUri = this.uriInfo.getRequestUri().toString();
        String path = requestUri.substring(baseUri.length() - 1);
        String clientContext = this.systemConfiguration.getClientContext();
        String adminContext = this.systemConfiguration.getAdminContext();
        try {
            if (path.equals(clientContext) || path.startsWith(clientContext + "/")) {
                this.authenticateClientRequest(requestContext);
            } else if (path.equals(adminContext) || path.startsWith(adminContext + "/")) {
                this.authenticateAdminRequest(requestContext);
            } else if (path.startsWith("/app")) {
                this.authenticateAdminRequest(requestContext);
            }
        }
        catch (NotAuthorizedException e) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"Notify\"").type("text/plain").entity((Object)"Not authorized").build());
        }
    }

    private void authenticateClientRequest(ContainerRequestContext requestContext) {
        DomainProfile domainProfile;
        if ("OPTIONS".equalsIgnoreCase(requestContext.getMethod())) {
            return;
        }
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null || !authHeader.startsWith("Basic ")) {
            throw new NotAuthorizedException((Object)"Notify", new Object[0]);
        }
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)(authHeader = authHeader.substring(6)));
        String basicAuth = new String(bytes, StandardCharsets.UTF_8);
        int pos = basicAuth.indexOf(":");
        if (pos < 0) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        String apiKey = basicAuth.substring(0, pos);
        String apiPassword = basicAuth.substring(pos + 1);
        if (StringUtils.isEmpty((Object)apiKey) || StringUtils.isEmpty((Object)apiPassword)) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        if (apiKey.equals("system") && apiPassword.equals("changeme")) {
            domainProfile = this.domainKernel.getSystemDomain();
        } else {
            try {
                domainProfile = this.domainKernel.findByApiKey(apiKey);
            }
            catch (ApiNotFoundException e) {
                throw new NotAuthorizedException((Object)"API", new Object[0]);
            }
            if (EqualsUtils.objectsNotEqual((Object)apiPassword, (Object)domainProfile.getApiPassword())) {
                throw new NotAuthorizedException((Object)"API", new Object[0]);
            }
        }
        if (EqualsUtils.objectsNotEqual((Object)apiPassword, (Object)domainProfile.getApiPassword())) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        SecurityContext securityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext((SecurityContext)new ClientSecurityContext(securityContext, domainProfile));
        this.executionManager.newApiContext(domainProfile, this.uriInfo, this.headers);
    }

    private void authenticateAdminRequest(ContainerRequestContext requestContext) {
        String authenticatedusername = null;
        if (this.systemConfiguration.isAutoAuthAdmin()) {
            authenticatedusername = "auto-admin";
        } else {
            String password;
            String username;
            String authHeader = requestContext.getHeaderString("Authorization");
            if (authHeader == null) {
                throw new NotAuthorizedException((Object)"API", new Object[0]);
            }
            if (!authHeader.startsWith("Basic ")) {
                throw new NotAuthorizedException((Object)"API", new Object[0]);
            }
            byte[] bytes = DatatypeConverter.parseBase64Binary((String)(authHeader = authHeader.substring(6)));
            String basicAuth = new String(bytes, StandardCharsets.UTF_8);
            int pos = basicAuth.indexOf(":");
            if (pos < 0) {
                username = basicAuth;
                password = null;
            } else {
                username = basicAuth.substring(0, pos);
                password = basicAuth.substring(pos + 1);
            }
            this.adminKernel.authorize(username, password);
            authenticatedusername = username;
        }
        SecurityContext securityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext((SecurityContext)new AdminSecurityContext(securityContext, authenticatedusername));
    }

    private class ClientSecurityContext
    implements SecurityContext {
        private final boolean secure;
        private final String domainName;
        private final Principal principal;

        public ClientSecurityContext(SecurityContext securityContext, DomainProfile domain) {
            this.secure = securityContext.isSecure();
            this.domainName = domain.getDomainName();
            this.principal = this::getDomainName;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            return "BASIC_AUTH";
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }
    }

    private class AdminSecurityContext
    implements SecurityContext {
        private final boolean secure;
        private final String username;

        public AdminSecurityContext(SecurityContext securityContext, String username) {
            this.username = username;
            this.secure = securityContext.isSecure();
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            return "BASIC_AUTH";
        }

        public Principal getUserPrincipal() {
            return this::getUsername;
        }
    }
}

