/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.request;

import java.net.URL;
import java.nio.file.Path;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.request.PutAttachmentRequest;
import org.tiogasolutions.couchace.core.api.request.PutDatabaseRequest;
import org.tiogasolutions.couchace.core.api.request.PutDesignRequest;
import org.tiogasolutions.couchace.core.api.request.PutDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.PutEntityRequest;
import org.tiogasolutions.couchace.core.internal.RequestExecutor;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;
import org.tiogasolutions.couchace.core.internal.util.IOUtil;

public class PutRequestFactory {
    private final RequestExecutor requestExecutor;

    public PutRequestFactory(RequestExecutor requestExecutor) {
        this.requestExecutor = requestExecutor;
    }

    public PutEntityRequest entity(Object entity) {
        ArgUtil.assertNotNull(entity, "entity");
        return new PutEntityRequest(this.requestExecutor, null, null, entity, null, null);
    }

    public PutEntityRequest entity(String documentId, String entityType, Object entity) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(entityType, "entityType");
        ArgUtil.assertNotNull(entity, "entity");
        return new PutEntityRequest(this.requestExecutor, documentId, entityType, entity, null, null);
    }

    public PutEntityRequest entity(String documentId, String entityType, Object entity, String documentRevision) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(entityType, "entityType");
        ArgUtil.assertNotNull(entity, "entity");
        ArgUtil.assertNotNull(documentRevision, "documentRevision");
        return new PutEntityRequest(this.requestExecutor, documentId, entityType, entity, documentRevision, null);
    }

    public PutEntityRequest entity(String documentId, String entityType, Object entity, CouchAttachmentInfoMap attachmentInfoMap) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(entityType, "entityType");
        ArgUtil.assertNotNull(entity, "entity");
        return new PutEntityRequest(this.requestExecutor, documentId, entityType, entity, null, attachmentInfoMap);
    }

    public PutEntityRequest entity(String documentId, String entityType, Object entity, String documentRevision, CouchAttachmentInfoMap attachmentInfoMap) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(entityType, "entityType");
        ArgUtil.assertNotNull(entity, "entity");
        ArgUtil.assertNotNull(documentRevision, "documentRevision");
        return new PutEntityRequest(this.requestExecutor, documentId, entityType, entity, documentRevision, attachmentInfoMap);
    }

    public PutEntityRequest entityCreateOrUpdate(String documentId, String entityType, Object entity, String documentRevision) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(entityType, "entityType");
        ArgUtil.assertNotNull(entity, "entity");
        return new PutEntityRequest(this.requestExecutor, documentId, entityType, entity, documentRevision, null);
    }

    public PutEntityRequest entityCreateOrUpdate(String documentId, String entityType, Object entity, String documentRevision, CouchAttachmentInfoMap attachmentInfoMap) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(entityType, "entityType");
        ArgUtil.assertNotNull(entity, "entity");
        return new PutEntityRequest(this.requestExecutor, documentId, entityType, entity, documentRevision, attachmentInfoMap);
    }

    public PutDocumentRequest document(String documentId, String document) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(document, "document");
        return new PutDocumentRequest(this.requestExecutor, documentId, document, null);
    }

    public PutDocumentRequest document(String documentId, String document, String documentRevision) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(document, "document");
        ArgUtil.assertNotNull(documentRevision, "documentRevision");
        return new PutDocumentRequest(this.requestExecutor, documentId, document, documentRevision);
    }

    public PutDocumentRequest documentCreateOrUpdate(String documentId, String document, String documentRevision) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(document, "document");
        return new PutDocumentRequest(this.requestExecutor, documentId, document, documentRevision);
    }

    public PutAttachmentRequest attachment(String documentId, String documentRevision, String attachmentName, CouchMediaType contentType, Object content) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(documentRevision, "documentRevision");
        ArgUtil.assertNotNull(attachmentName, "attachmentName");
        ArgUtil.assertNotNull(contentType, "contentType");
        ArgUtil.assertNotNull(content, "content");
        return new PutAttachmentRequest(this.requestExecutor, documentId, documentRevision, attachmentName, contentType, content);
    }

    public PutDatabaseRequest database(String path, String content) {
        ArgUtil.assertNotNull(path, "path");
        ArgUtil.assertNotNull(content, "content");
        return new PutDatabaseRequest(this.requestExecutor, path, content);
    }

    public PutDatabaseRequest database(String path) {
        ArgUtil.assertNotNull(path, "path");
        return new PutDatabaseRequest(this.requestExecutor, path, null);
    }

    public PutDatabaseRequest database() {
        return new PutDatabaseRequest(this.requestExecutor, null, null);
    }

    public PutDesignRequest design(String designName, String designContent) {
        ArgUtil.assertNotNull(designName, "designName");
        ArgUtil.assertNotNull(designContent, "designContent");
        return new PutDesignRequest(this.requestExecutor, designName, designContent, null);
    }

    public PutDesignRequest design(String designName, Path designFile) {
        ArgUtil.assertNotNull(designName, "designName");
        ArgUtil.assertNotNull(designFile, "designFile");
        String designBody = IOUtil.readText(designFile);
        return new PutDesignRequest(this.requestExecutor, designName, designBody, null);
    }

    public PutDesignRequest design(String designName, URL designFile) {
        ArgUtil.assertNotNull(designName, "designName");
        ArgUtil.assertNotNull(designFile, "designFile");
        String designBody = IOUtil.readText(designFile);
        return new PutDesignRequest(this.requestExecutor, designName, designBody, null);
    }

    public PutDesignRequest design(String designName, String designContent, String documentRevision) {
        ArgUtil.assertNotNull(designName, "designName");
        ArgUtil.assertNotNull(designContent, "designContent");
        ArgUtil.assertNotNull(documentRevision, "documentRevision");
        return new PutDesignRequest(this.requestExecutor, designName, designContent, documentRevision);
    }

    public PutDesignRequest design(String designName, Path designFile, String documentRevision) {
        ArgUtil.assertNotNull(designName, "designName");
        ArgUtil.assertNotNull(designFile, "designContent");
        ArgUtil.assertNotNull(documentRevision, "documentRevision");
        String designBody = IOUtil.readText(designFile);
        return new PutDesignRequest(this.requestExecutor, designName, designBody, documentRevision);
    }

    public PutDesignRequest design(String designName, URL designFile, String documentRevision) {
        ArgUtil.assertNotNull(designName, "designName");
        ArgUtil.assertNotNull(designFile, "designFile");
        ArgUtil.assertNotNull(documentRevision, "documentRevision");
        String designBody = IOUtil.readText(designFile);
        return new PutDesignRequest(this.requestExecutor, designName, designBody, documentRevision);
    }
}

