/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.lib.hal.HalItem;
import org.tiogasolutions.lib.hal.HalItemWrapper;
import org.tiogasolutions.lib.hal.HalLink;
import org.tiogasolutions.lib.hal.HalLinks;
import org.tiogasolutions.lib.hal.HalLinksBuilder;
import org.tiogasolutions.notify.pub.domain.DomainProfile;

public class PubUtils {
    private boolean excludeLinks;
    private final UriInfo uriInfo;

    public PubUtils(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public PubUtils(ContainerRequestContext requestContext) {
        this.uriInfo = requestContext.getUriInfo();
    }

    public Response.ResponseBuilder toResponse(HalItem item) {
        int statusCode = item.getHttpStatusCode().getCode();
        Response.ResponseBuilder builder = Response.status((int)statusCode).entity((Object)item);
        if (statusCode == HttpStatusCode.CREATED.getCode()) {
            HalLink link = item.get_links().getLink("self");
            builder.location(link.getHrefUri());
        }
        for (Map.Entry entry : item.get_links().entrySet()) {
            String rel = (String)entry.getKey();
            HalLink link = (HalLink)entry.getValue();
            builder.link(link.getHref(), rel);
        }
        return builder;
    }

    public HalItem fromDomainProfile(HttpStatusCode statusCode, DomainProfile profile) {
        HalLinks links = HalLinks.builder().create("self", this.uriAdminDomain(profile.getDomainName())).create("domains", this.uriAdminDomains()).build();
        return new HalItemWrapper((Object)profile, statusCode, links);
    }

    public HalItem fromDomainProfileResults(HttpStatusCode statusCode, List<DomainProfile> profiles) {
        HalLinks links = HalLinks.builder().create("self", this.uriAdminDomains()).build();
        ArrayList<HalItem> items = new ArrayList<HalItem>();
        for (DomainProfile profile : profiles) {
            HalItem item = this.fromDomainProfile(null, profile);
            items.add(item);
        }
        ListQueryResult itemResults = ListQueryResult.newComplete(HalItem.class, items);
        return new HalItemWrapper((Object)itemResults, statusCode, links);
    }

    public boolean isExcludeLinks() {
        return this.excludeLinks;
    }

    public void setExcludeLinks(boolean excludeLinks) {
        this.excludeLinks = excludeLinks;
    }

    public String uriAdmin() {
        return this.uriInfo.getBaseUriBuilder().path("/api/v2/admin").toString();
    }

    public String uriAdminDomains() {
        return this.uriInfo.getBaseUriBuilder().path("/api/v2/admin").path("/domains").toString();
    }

    public String uriAdminDomain(String domainName) {
        return this.uriInfo.getBaseUriBuilder().path("/api/v2/admin").path("/domains").path(domainName).toString();
    }

    public Response.ResponseBuilder toAdmin() {
        HalLinks links = HalLinksBuilder.builder().create("self", this.uriAdmin()).create("domains", this.uriAdminDomains()).build();
        HalItem item = new HalItem(HttpStatusCode.OK, links);
        return Response.ok((Object)item);
    }
}

