/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.lib.hal.HalItem;
import org.tiogasolutions.lib.hal.HalLinks;
import org.tiogasolutions.lib.hal.HalLinksBuilder;
import org.tiogasolutions.notify.engine.v2.NotificationRequestResourceV2;
import org.tiogasolutions.notify.engine.v2.NotificationsResourceV2;
import org.tiogasolutions.notify.engine.v2.RouteCatalogResourceV2;
import org.tiogasolutions.notify.engine.v2.TasksResourceV2;
import org.tiogasolutions.notify.kernel.PubUtils;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.receiver.ReceiverExecutor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorExecutor;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.domain.DomainSummary;

public class AdminDomainResourceV2 {
    private final PubUtils pubUtils;
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final NotificationKernel notificationKernel;
    private final ReceiverExecutor receiverExecutor;
    private final TaskProcessorExecutor processorExecutor;
    private final EventBus eventBus;
    private final String domainName;

    public AdminDomainResourceV2(PubUtils pubUtils, ExecutionManager executionManager, DomainKernel domainKernel, NotificationKernel notificationKernel, ReceiverExecutor receiverExecutor, TaskProcessorExecutor processorExecutor, EventBus eventBus, String domainName) {
        this.pubUtils = pubUtils;
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
        this.notificationKernel = notificationKernel;
        this.receiverExecutor = receiverExecutor;
        this.processorExecutor = processorExecutor;
        this.domainName = domainName;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDomainProfile() {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(this.domainName);
        HalItem item = this.pubUtils.fromDomainProfile(HttpStatusCode.CREATED, domainProfile);
        return this.pubUtils.toResponse(item).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteDomain() {
        this.domainKernel.deleteDomain(this.domainName);
        HalLinks links = HalLinksBuilder.builder().create("domains", this.pubUtils.uriAdminDomains()).build();
        HalItem item = new HalItem(HttpStatusCode.OK, links);
        return this.pubUtils.toResponse(item).build();
    }

    @GET
    @Path(value="/summary")
    @Produces(value={"application/json"})
    public Response getDomainSummary() {
        DomainSummary summary = this.domainKernel.fetchSummary(this.domainName);
        return Response.ok((Object)summary).build();
    }

    @Path(value="/notifications")
    public NotificationsResourceV2 getNotificationsResourceV1(@Context Request request) {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(this.domainName);
        this.executionManager.newApiContext(domainProfile);
        return new NotificationsResourceV2(request, this.executionManager, this.notificationKernel);
    }

    @Path(value="/route-catalog")
    public RouteCatalogResourceV2 getRouteCatalogResourceV1() {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(this.domainName);
        this.executionManager.newApiContext(domainProfile);
        return new RouteCatalogResourceV2(this.executionManager, this.domainKernel);
    }

    @Path(value="/requests")
    public NotificationRequestResourceV2 getRequestResourceV1() {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(this.domainName);
        this.executionManager.newApiContext(domainProfile);
        return new NotificationRequestResourceV2(this.executionManager, this.domainKernel, this.eventBus);
    }

    @Path(value="/tasks")
    public TasksResourceV2 getTasksResourceV1() {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(this.domainName);
        this.executionManager.newApiContext(domainProfile);
        return new TasksResourceV2(this.executionManager, this.domainKernel, this.notificationKernel);
    }
}

