/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.route.RouteCatalog;

public class RouteCatalogResourceV2 {
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;

    public RouteCatalogResourceV2(ExecutionManager executionManager, DomainKernel domainKernel) {
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
    }

    private DomainProfile getDomainProfile() {
        ExecutionContext ec = this.executionManager.context();
        return this.domainKernel.findByApiKey(ec.getApiKey());
    }

    @GET
    @Produces(value={"application/json"})
    public RouteCatalog getRouteCatalog() {
        return this.getDomainProfile().getRouteCatalog();
    }

    @PUT
    @Produces(value={"application/json"})
    public RouteCatalog putRouteCatalog(RouteCatalog routeCatalog) {
        DomainProfile returnProfile = this.domainKernel.updateRouteCatalog(this.getDomainProfile(), routeCatalog);
        return returnProfile.getRouteCatalog();
    }
}

