/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.request.NotificationRequestEntity;
import org.tiogasolutions.notify.kernel.request.NotificationRequestStore;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.request.NotificationRequest;
import org.tiogasolutions.notify.pub.request.NotificationRequestStatus;

public class SimpleRequestEntryResourceV2 {
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final EventBus eventBus;

    public SimpleRequestEntryResourceV2(ExecutionManager executionManager, DomainKernel domainKernel, EventBus eventBus) {
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
    }

    private DomainProfile getDomainProfile() {
        ExecutionContext ec = this.executionManager.context();
        return this.domainKernel.findByApiKey(ec.getApiKey());
    }

    @POST
    public Response postRequest(@Context UriInfo uriInfo, NotificationRequest request) {
        CouchDatabase requestDb = this.domainKernel.requestDb(this.getDomainProfile());
        NotificationRequestStore store = new NotificationRequestStore(requestDb);
        NotificationRequestEntity notificationRequestEntity = NotificationRequestEntity.newEntity((NotificationRequest)request);
        if ((notificationRequestEntity = store.saveAndReload(notificationRequestEntity)).getRequestStatus() != NotificationRequestStatus.READY) {
            notificationRequestEntity.ready();
            notificationRequestEntity = store.saveAndReload(notificationRequestEntity);
        }
        String domainName = this.executionManager.context().getDomainName();
        this.eventBus.requestCreated(domainName, notificationRequestEntity);
        URI uri = uriInfo.getRequestUriBuilder().path(notificationRequestEntity.getRequestId()).build(new Object[0]);
        return Response.created((URI)uri).build();
    }
}

