/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import java.util.ArrayList;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jvnet.hk2.annotations.Optional;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.task.Task;
import org.tiogasolutions.notify.pub.task.TaskQuery;
import org.tiogasolutions.notify.pub.task.TaskStatus;

public class TasksResourceV2 {
    private final DomainKernel domainKernel;
    private final NotificationKernel notificationKernelnel;
    private final ExecutionManager executionManager;

    public TasksResourceV2(ExecutionManager executionManager, DomainKernel domainKernel, NotificationKernel notificationKernelnel) {
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
        this.notificationKernelnel = notificationKernelnel;
    }

    private DomainProfile getDomainProfile() {
        ExecutionContext ec = this.executionManager.context();
        return this.domainKernel.findByApiKey(ec.getApiKey());
    }

    @GET
    @Produces(value={"application/json"})
    public QueryResult<Task> getTasks(@Optional @QueryParam(value="taskStatus") TaskStatus taskStatus) {
        TaskQuery query = new TaskQuery().setTaskStatus(taskStatus);
        ArrayList tasks = new ArrayList();
        QueryResult result = this.notificationKernelnel.query(query);
        result.getResults().stream().forEach(task -> tasks.add(task.toTask()));
        return ListQueryResult.newResult(Task.class, (int)result.getLimit(), (int)result.getOffset(), (int)result.getTotalFound(), (boolean)result.isTotalExact(), tasks);
    }

    @DELETE
    @Path(value="{taskId}")
    @Produces(value={"application/json"})
    public Response deleteTask(@PathParam(value="taskId") String taskId) {
        this.notificationKernelnel.deleteTask(taskId);
        return Response.noContent().build();
    }
}

