/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaScriptUtils {
    public static String escapeString(String str) {
        return StringUtils.escapeJavaScript(str);
    }

    public static String print(Object object) {
        StringBuilder output = new StringBuilder();
        JavaScriptUtils.print(output, object);
        return output.toString();
    }

    public static String printString(String str) {
        StringBuilder output = new StringBuilder();
        if (str == null) {
            JavaScriptUtils.printNull(output);
        } else {
            JavaScriptUtils.printString(output, str);
        }
        return output.toString();
    }

    public static String printNumber(Number number) {
        StringBuilder output = new StringBuilder();
        if (number == null) {
            JavaScriptUtils.printNull(output);
        } else {
            JavaScriptUtils.printNumber(output, number);
        }
        return output.toString();
    }

    public static String printBoolean(Boolean bool) {
        StringBuilder output = new StringBuilder();
        if (bool == null) {
            JavaScriptUtils.printNull(output);
        } else {
            JavaScriptUtils.printBoolean(output, bool);
        }
        return output.toString();
    }

    public static String printCollection(Collection<?> collection) {
        StringBuilder output = new StringBuilder();
        if (collection == null) {
            JavaScriptUtils.printNull(output);
        } else {
            JavaScriptUtils.printCollection(output, collection);
        }
        return output.toString();
    }

    public static String printArray(Object array) {
        StringBuilder output = new StringBuilder();
        if (array == null) {
            JavaScriptUtils.printNull(output);
        } else {
            JavaScriptUtils.printArray(output, array);
        }
        return output.toString();
    }

    public static String printMap(Map<?, ?> map) {
        StringBuilder output = new StringBuilder();
        if (map == null) {
            JavaScriptUtils.printNull(output);
        } else {
            JavaScriptUtils.printMap(output, map);
        }
        return output.toString();
    }

    public static String printObject(Object object) {
        StringBuilder output = new StringBuilder();
        if (object == null) {
            JavaScriptUtils.printNull(output);
        } else {
            JavaScriptUtils.printObject(output, object);
        }
        return output.toString();
    }

    private static void print(StringBuilder output, Object object) {
        if (object == null) {
            JavaScriptUtils.printNull(output);
            return;
        }
        if (object instanceof String) {
            JavaScriptUtils.printString(output, (String)object);
            return;
        }
        if (object instanceof Character) {
            JavaScriptUtils.printString(output, object.toString());
            return;
        }
        if (object instanceof Number) {
            JavaScriptUtils.printNumber(output, (Number)object);
            return;
        }
        if (object instanceof Boolean) {
            JavaScriptUtils.printBoolean(output, (Boolean)object);
            return;
        }
        if (object instanceof Date) {
            JavaScriptUtils.printDate(output, (Date)object);
            return;
        }
        if (object.getClass().isArray()) {
            JavaScriptUtils.printArray(output, object);
            return;
        }
        if (object instanceof Collection) {
            JavaScriptUtils.printCollection(output, (Collection)object);
            return;
        }
        if (object instanceof Map) {
            JavaScriptUtils.printMap(output, (Map)object);
            return;
        }
        if (object.getClass().isEnum()) {
            JavaScriptUtils.printEnum(output, object);
            return;
        }
        JavaScriptUtils.printObject(output, object);
    }

    private static void printNull(StringBuilder output) {
        output.append("null");
    }

    private static void printString(StringBuilder output, String str) {
        output.append('\'');
        output.append(StringUtils.escapeJavaScript(str));
        output.append('\'');
    }

    private static void printNumber(StringBuilder output, Number number) {
        output.append(number.toString());
    }

    private static void printBoolean(StringBuilder output, Boolean bool) {
        output.append(bool.toString());
    }

    private static void printDate(StringBuilder output, Date date) {
        output.append((date instanceof java.sql.Date ? new Date(date.getTime()) : date).toString());
    }

    private static void printArray(StringBuilder output, Object arrayObj) {
        output.append('[');
        if (arrayObj instanceof Object[]) {
            Object[] array = (Object[])arrayObj;
            boolean first = true;
            for (Object element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                JavaScriptUtils.print(output, element);
            }
        } else if (arrayObj instanceof boolean[]) {
            boolean[] array = (boolean[])arrayObj;
            boolean first = true;
            for (boolean element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                JavaScriptUtils.print(output, element);
            }
        } else if (arrayObj instanceof byte[]) {
            byte[] array = (byte[])arrayObj;
            boolean first = true;
            for (byte element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                JavaScriptUtils.print(output, element);
            }
        } else if (arrayObj instanceof short[]) {
            short[] array = (short[])arrayObj;
            boolean first = true;
            for (short element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                JavaScriptUtils.print(output, element);
            }
        } else if (arrayObj instanceof int[]) {
            int[] array = (int[])arrayObj;
            boolean first = true;
            for (int element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                JavaScriptUtils.print(output, element);
            }
        } else if (arrayObj instanceof long[]) {
            long[] array = (long[])arrayObj;
            boolean first = true;
            for (long element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                JavaScriptUtils.print(output, element);
            }
        } else if (arrayObj instanceof float[]) {
            float[] array = (float[])arrayObj;
            boolean first = true;
            for (float element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                JavaScriptUtils.print(output, Float.valueOf(element));
            }
        } else if (arrayObj instanceof double[]) {
            double[] array = (double[])arrayObj;
            boolean first = true;
            for (double element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                JavaScriptUtils.print(output, element);
            }
        } else {
            throw new IllegalArgumentException("Cannot print \"" + arrayObj + "\" of class " + arrayObj.getClass().getName() + " as an array");
        }
        output.append(']');
    }

    private static void printCollection(StringBuilder output, Collection<?> collection) {
        output.append('[');
        boolean first = true;
        for (Object element : collection) {
            if (first) {
                first = false;
            } else {
                output.append(',');
            }
            JavaScriptUtils.print(output, element);
        }
        output.append(']');
    }

    private static void printMap(StringBuilder output, Map<?, ?> map) {
        output.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                output.append(',');
            }
            JavaScriptUtils.printKeyValue(output, entry.getKey(), entry.getValue());
        }
        output.append('}');
    }

    private static void printKeyValue(StringBuilder output, Object key, Object value) {
        JavaScriptUtils.print(output, key);
        output.append(':');
        JavaScriptUtils.print(output, value);
    }

    private static void printObject(StringBuilder output, Object object) {
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(descriptors.length + 1, 1.0f);
            for (PropertyDescriptor descriptor : descriptors) {
                String name;
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null || "class".equals((name = descriptor.getName()).toLowerCase())) continue;
                Object value = readMethod.invoke(object, new Object[0]);
                properties.put(name, value);
            }
            JavaScriptUtils.printMap(output, properties);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
        }
    }

    private static void printEnum(StringBuilder output, Object object) {
        Enum enumObject = (Enum)object;
        Class<?> enumClass = object.getClass();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(3, 1.0f);
        properties.put("$type", enumClass.getSimpleName());
        properties.put("$name", enumObject.name());
        JavaScriptUtils.printMap(output, properties);
    }

    private JavaScriptUtils() {
    }
}

