/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.hal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.lib.hal.HalCurie;

public class HalLink {
    private final String href;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String title;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean templated;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String deprecation;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<HalCurie> curies;
    @JsonIgnore
    private final String name;
    @JsonIgnore
    private final String type;
    @JsonIgnore
    private final URI profile = null;
    @JsonIgnore
    private final String hreflang;

    private HalLink() {
        this.name = null;
        this.type = null;
        this.hreflang = null;
        this.href = null;
        this.title = null;
        this.templated = false;
        this.deprecation = null;
        this.curies = Collections.emptyList();
    }

    @JsonCreator
    protected HalLink(@JsonProperty(value="href") String href, @JsonProperty(value="title") String title, @JsonProperty(value="templated") boolean templated, @JsonProperty(value="deprecation") String deprecation, @JsonProperty(value="curies") List<HalCurie> curies) {
        this.name = null;
        this.type = null;
        this.hreflang = null;
        this.href = href;
        this.title = title;
        this.templated = templated;
        this.deprecation = deprecation;
        if (curies == null) {
            curies = Collections.emptyList();
        }
        this.curies = Collections.unmodifiableList(curies);
    }

    public String getHref() {
        return this.href;
    }

    @JsonIgnore
    public URI getHrefUri() {
        return URI.create(this.href);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isTemplated() {
        return this.templated;
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public List<HalCurie> getCuries() {
        return this.curies;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public URI getProfile() {
        return this.profile;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    public HalLink deprecation(URI deprecation) {
        return this.deprecation(deprecation.toString());
    }

    public HalLink deprecation(String deprecation) {
        return new HalLink(this.href, this.title, this.templated, deprecation, this.curies);
    }

    public HalLink templated() {
        return new HalLink(this.href, this.title, true, this.deprecation, this.curies);
    }

    public static HalLink create(URI href) {
        String url = href.toString();
        return new HalLink(url, null, false, null, null);
    }

    public static HalLink create(String href) {
        return new HalLink(href, null, false, null, null);
    }

    public static HalLink create(URI href, String title) {
        String url = href.toString();
        return new HalLink(url, title, false, null, null);
    }

    public static HalLink create(String href, String title) {
        return new HalLink(href, title, false, null, null);
    }
}

