/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common.fine;

import java.io.Serializable;
import java.util.Map;
import org.tiogasolutions.dev.common.fine.FineMessageSet;
import org.tiogasolutions.dev.common.fine.FineMessageSetBuilder;
import org.tiogasolutions.dev.common.fine.TraitMap;

public class FineMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String text;
    private final String id;
    private final TraitMap traitMap;

    public static FineMessage withText(String text) {
        return new FineMessage(text, null, TraitMap.empty());
    }

    public static FineMessage withId(String text, String id) {
        return new FineMessage(text, id, TraitMap.empty());
    }

    public static FineMessage withTraits(String text, TraitMap traitMap) {
        return new FineMessage(text, null, traitMap);
    }

    public static FineMessage withTraits(String text, Map<String, String> traitMap) {
        return new FineMessage(text, null, new TraitMap(traitMap));
    }

    public static FineMessage withTraits(String text, String ... traits) {
        return new FineMessage(text, null, new TraitMap(traits));
    }

    public static FineMessage withAll(String text, String id, String ... traits) {
        return new FineMessage(text, id, new TraitMap(traits));
    }

    public static FineMessage withAll(String text, String id, TraitMap traitMap) {
        return new FineMessage(text, id, traitMap);
    }

    protected FineMessage(String text, String id, TraitMap traitMap) {
        this.text = text != null ? text : "";
        this.id = id;
        if (traitMap == null) {
            this.traitMap = TraitMap.empty();
        } else {
            Map<String, String> map = traitMap.getMap();
            this.traitMap = new TraitMap(map);
        }
    }

    public boolean isId(String id) {
        return this.id == null ? id == null : this.id.equals(id);
    }

    public boolean isText(String givenText) {
        return this.text.equalsIgnoreCase(givenText);
    }

    public String getDisplay() {
        StringBuilder sb = new StringBuilder();
        if (this.id != null) {
            sb.append(this.id);
            sb.append(": ");
        }
        sb.append(this.text);
        if (this.traitMap.isNotEmpty()) {
            sb.append(" [");
            sb.append(this.traitMap);
            sb.append("]");
        }
        return sb.toString();
    }

    public String getText() {
        return this.text;
    }

    public String getId() {
        return this.id;
    }

    public TraitMap getTraitMap() {
        return this.traitMap;
    }

    public boolean hasTraits() {
        return this.traitMap.isNotEmpty();
    }

    public boolean hasTrait(String key) {
        return this.traitMap.hasTrait(key);
    }

    public boolean hasValue(String key, String checkValue) {
        return this.traitMap.hasValue(key, checkValue);
    }

    public String getTraitValue(String traitName) {
        return this.traitMap.getValue(traitName);
    }

    public int getTraitCount() {
        return this.getTraitMap().getSize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FineMessage that = (FineMessage)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (!this.text.equals(that.text)) {
            return false;
        }
        return this.traitMap.equals(that.traitMap);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result = 31 * result + this.text.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + this.traitMap.hashCode();
        return result;
    }

    public String toString() {
        return this.getDisplay();
    }

    public FineMessageSet toSet() {
        return new FineMessageSetBuilder().withMessage(this).build();
    }
}

