/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import org.tiogasolutions.dev.common.BeanUtils;
import org.tiogasolutions.dev.common.exceptions.ApiBadRequestException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.route.DestinationStatus;

public class DestinationDef {
    private final String name;
    private final String provider;
    private DestinationStatus destinationStatus;
    private final Map<String, String> arguments;

    public DestinationDef(String name, DestinationStatus destinationStatus, String provider, String ... arguments) {
        this(name, destinationStatus, provider, BeanUtils.toMap((String[])arguments));
    }

    @JsonCreator
    public DestinationDef(@JsonProperty(value="name") String name, @JsonProperty(value="destinationStatus") DestinationStatus destinationStatus, @JsonProperty(value="provider") String provider, @JsonProperty(value="arguments") Map<String, String> arguments) {
        this.name = ExceptionUtils.assertNotZeroLength((String)name, (String)"name", ApiBadRequestException.class, ApiBadRequestException.class);
        this.provider = ExceptionUtils.assertNotZeroLength((String)provider, (String)"provider", ApiBadRequestException.class, ApiBadRequestException.class);
        this.destinationStatus = (DestinationStatus)((Object)ExceptionUtils.assertNotNull((Object)((Object)destinationStatus), (String)"destinationStatus", ApiBadRequestException.class));
        this.arguments = arguments != null ? Collections.unmodifiableMap(arguments) : Collections.emptyMap();
    }

    public Destination toDestination() {
        return new Destination(this.name, this.provider, this.destinationStatus, this.arguments);
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }

    public DestinationStatus getDestinationStatus() {
        return this.destinationStatus;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationDef that = (DestinationDef)o;
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.destinationStatus != that.destinationStatus) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.provider != null ? !this.provider.equals(that.provider) : that.provider != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        result = 31 * result + (this.destinationStatus != null ? this.destinationStatus.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DestinationDef{name='" + this.name + '\'' + ", provider='" + this.provider + '\'' + ", destinationStatus=" + (Object)((Object)this.destinationStatus) + ", arguments=" + this.arguments + '}';
    }
}

