/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.dev.common.exceptions.ApiBadRequestException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.route.RouteStatus;

public class Route {
    private final String name;
    private final String eval;
    private final RouteStatus routeStatus;
    private final List<Destination> destinations;

    @JsonCreator
    public Route(@JsonProperty(value="name") String name, @JsonProperty(value="routeStatus") RouteStatus routeStatus, @JsonProperty(value="eval") String eval, @JsonProperty(value="destinations") List<Destination> destinations) {
        this.name = ExceptionUtils.assertNotZeroLength((String)name, (String)"name", ApiBadRequestException.class, ApiBadRequestException.class);
        this.eval = ExceptionUtils.assertNotZeroLength((String)eval, (String)"eval", ApiBadRequestException.class, ApiBadRequestException.class);
        this.routeStatus = (RouteStatus)((Object)ExceptionUtils.assertNotNull((Object)((Object)routeStatus), (String)"routeStatus", ApiBadRequestException.class));
        this.destinations = destinations != null ? Collections.unmodifiableList(destinations) : Collections.emptyList();
    }

    public RouteStatus getRouteStatus() {
        return this.routeStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getEval() {
        return this.eval;
    }

    public List<Destination> getDestinations() {
        return this.destinations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route route = (Route)o;
        if (this.name != null ? !this.name.equals(route.name) : route.name != null) {
            return false;
        }
        if (this.eval != null ? !this.eval.equals(route.eval) : route.eval != null) {
            return false;
        }
        if (this.routeStatus != route.routeStatus) {
            return false;
        }
        return this.destinations != null ? this.destinations.equals(route.destinations) : route.destinations == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.eval != null ? this.eval.hashCode() : 0);
        result = 31 * result + (this.routeStatus != null ? this.routeStatus.hashCode() : 0);
        result = 31 * result + (this.destinations != null ? this.destinations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Route{name='" + this.name + '\'' + ", eval='" + this.eval + '\'' + ", routeStatus=" + (Object)((Object)this.routeStatus) + ", destinations=" + this.destinations + '}';
    }
}

