/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jvnet.hk2.config.ConfigurationException;

public class UnsatisfiedDependencyException
extends ConfigurationException {
    final AnnotatedElement member;

    public UnsatisfiedDependencyException(AnnotatedElement target) {
        this(target, null, null);
    }

    public UnsatisfiedDependencyException(AnnotatedElement target, Annotation inject) {
        this(target, inject, null);
    }

    public UnsatisfiedDependencyException(AnnotatedElement target, Annotation inject, Throwable cause) {
        super(UnsatisfiedDependencyException.injection_failed_msg(target, inject, cause), cause);
        this.member = target;
    }

    public UnsatisfiedDependencyException(Type target, Class<?> targetClass, Annotation inject, Throwable cause) {
        super(UnsatisfiedDependencyException.injection_failed_msg(target, inject, null), inject, cause);
        this.member = targetClass;
    }

    static String injection_failed_msg(Object t, Annotation inject, Throwable cause) {
        String msg;
        String name = null;
        String string = name = null == name || name.isEmpty() ? null : name;
        if (Field.class.isInstance(t)) {
            Field target = (Field)Field.class.cast(t);
            msg = "injection failed on " + target.getDeclaringClass().getName() + "." + target.getName() + " with " + target.getGenericType() + (null == name ? "" : " and name '" + name + "'");
        } else {
            msg = "injection failed on " + t + (null == name ? "" : " with name '" + name + "'");
        }
        return msg;
    }

    public boolean isField() {
        return this.member instanceof Field;
    }

    public boolean isMethod() {
        return this.member instanceof Method;
    }

    public String getUnsatisfiedName() {
        String name;
        String string = name = this.member instanceof Member ? ((Member)((Object)this.member)).getName() : this.member.toString();
        if (this.isMethod()) {
            return name.substring(3).toLowerCase();
        }
        return name;
    }

    public AnnotatedElement getUnsatisfiedElement() {
        try {
            return (AnnotatedElement)AnnotatedElement.class.cast(this.member);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        AnnotatedElement annotated = this.getUnsatisfiedElement();
        if (annotated != null) {
            return annotated.getAnnotation(annotationType);
        }
        return null;
    }
}

