/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.pub;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tiogasolutions.dev.common.BeanUtils;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.push.pub.common.CommonEmail;
import org.tiogasolutions.push.pub.common.Push;
import org.tiogasolutions.push.pub.common.PushType;
import org.tiogasolutions.push.pub.internal.PushUtils;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class SmtpEmailPush
implements CommonEmail,
Push,
Serializable {
    public static final PushType PUSH_TYPE = new PushType(SmtpEmailPush.class, "smtp-email", "SMTP E-Mail");
    private final String fromAddress;
    private final String toAddress;
    private final String emailSubject;
    private final String htmlContent;
    private final LinkedHashMap<String, String> traits = new LinkedHashMap();
    private final String remoteHost;
    private final String remoteAddress;
    private final String callbackUrl;

    private SmtpEmailPush(@JsonProperty(value="toAddress") String toAddress, @JsonProperty(value="fromAddress") String fromAddress, @JsonProperty(value="emailSubject") String emailSubject, @JsonProperty(value="htmlContent") String htmlContent, @JsonProperty(value="callbackUrl") String callbackUrl, @JsonProperty(value="remoteHost") String remoteHost, @JsonProperty(value="remoteAddress") String remoteAddress, @JsonProperty(value="traits") Map<String, String> traits) {
        String[] keys;
        this.toAddress = toAddress;
        this.fromAddress = fromAddress;
        this.emailSubject = emailSubject;
        String content = StringUtils.getTagContents((Object)htmlContent, (String)"body", (int)0);
        this.htmlContent = StringUtils.isNotBlank((Object)content) ? content : htmlContent;
        this.callbackUrl = callbackUrl;
        this.remoteHost = remoteHost;
        this.remoteAddress = remoteAddress;
        if (traits != null) {
            this.traits.putAll(traits);
        }
        for (String key : keys = (String[])ReflectUtils.toArray(String.class, this.traits.keySet())) {
            if (!StringUtils.isBlank((Object)this.traits.get(key))) continue;
            this.traits.remove(key);
        }
    }

    @Override
    public PushType getPushType() {
        return PUSH_TYPE;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getFromAddress() {
        return this.fromAddress;
    }

    @Override
    public String getToAddress() {
        return this.toAddress;
    }

    @Override
    public String getEmailSubject() {
        return this.emailSubject;
    }

    @Override
    public String getHtmlContent() {
        return this.htmlContent;
    }

    @Override
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Override
    public Map<String, String> getTraits() {
        return this.traits;
    }

    @Override
    public RequestErrors validate(RequestErrors errors) {
        ValidationUtils.requireValue(errors, this.toAddress, "The \"to\" address must be specified.");
        ValidationUtils.requireValue(errors, this.fromAddress, "The \"from\" address must be specified.");
        if (StringUtils.isBlank((Object)this.emailSubject) && StringUtils.isBlank((Object)this.htmlContent)) {
            errors.add("At least the subject and/or the HTML content must be specified.");
        }
        return errors;
    }

    public static SmtpEmailPush newPush(String toAddress, String fromAddress, String emailSubject, String htmlContent, String callbackUrl, String ... traits) {
        InetAddress remoteAddress = PushUtils.getLocalHost();
        return new SmtpEmailPush(toAddress, fromAddress, emailSubject, htmlContent, callbackUrl, remoteAddress.getCanonicalHostName(), remoteAddress.getHostAddress(), BeanUtils.toMap((String[])traits));
    }

    public static SmtpEmailPush newPush(String toAddress, String fromAddress, String emailSubject, String htmlContent, String callbackUrl, Map<String, String> traits) {
        InetAddress remoteAddress = PushUtils.getLocalHost();
        return new SmtpEmailPush(toAddress, fromAddress, emailSubject, htmlContent, callbackUrl, remoteAddress.getCanonicalHostName(), remoteAddress.getHostAddress(), traits);
    }
}

