/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.domain;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.request.CouchFeatureSet;
import org.tiogasolutions.couchace.core.api.response.GetDocumentResponse;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;
import org.tiogasolutions.couchace.core.api.response.TextDocument;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.kernel.common.AbstractStore;
import org.tiogasolutions.notify.kernel.config.CouchServers;
import org.tiogasolutions.notify.kernel.config.CouchServersConfig;
import org.tiogasolutions.notify.kernel.domain.DomainProfileEntity;
import org.tiogasolutions.notify.pub.common.TopicInfo;
import org.tiogasolutions.notify.pub.common.TraitInfo;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.domain.DomainSummary;
import org.tiogasolutions.notify.pub.route.RouteCatalog;

@Component
public class DomainStore
extends AbstractStore {
    private static final Logger log = LoggerFactory.getLogger(DomainStore.class);
    private final CouchServers couchServers;
    private final CouchServer notificationCouchServer;
    private final CouchServer requestCouchServer;
    private static final String USER_JSON_TEMPLATE = "{\"_id\": \"%s\",\"name\": \"%s\",\"type\": \"user\",\"roles\": [],\"password\": \"%s\"}";

    @Autowired
    public DomainStore(CouchServers couchServers) {
        super(couchServers.getMasterDatabase());
        this.couchServers = couchServers;
        this.notificationCouchServer = couchServers.getNotificationServer();
        this.requestCouchServer = couchServers.getRequestServer();
    }

    public boolean hasDomain(String domainName) {
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)"DomainProfile", (String)"ByDomainName").key(new Object[]{domainName}).build();
        GetEntityResponse response = this.couchDatabase.get().entity(DomainProfileEntity.class, viewQuery).onError(r -> this.throwError(r, String.format("Failure retrieving active domain profile by name [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        return response.isNotEmpty();
    }

    public DomainProfileEntity findByProfileId(String profileId) {
        GetEntityResponse response = this.couchDatabase.get().entity(DomainProfileEntity.class, profileId).onError(r -> this.throwError(r, String.format("Failure retrieving domain profile in couch [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).onResponse(r -> this.throwIfNotFound((GetEntityResponse)r, "Domain profile not found by profile id " + profileId)).execute();
        return (DomainProfileEntity)response.getFirstEntity();
    }

    public QueryResult<DomainProfileEntity> findByDomainNames(String domainName) {
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)"DomainProfile", (String)"ByDomainName").key(new Object[]{domainName}).build();
        GetEntityResponse response = this.couchDatabase.get().entity(DomainProfileEntity.class, viewQuery).onError(r -> this.throwError(r, String.format("Failure retrieving active domain profile by name [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        return ListQueryResult.newComplete(DomainProfileEntity.class, (Collection)response.getEntityList());
    }

    public DomainProfileEntity findByDomainName(String domainName) {
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)"DomainProfile", (String)"ByDomainName").key(new Object[]{domainName}).build();
        GetEntityResponse response = this.couchDatabase.get().entity(DomainProfileEntity.class, viewQuery).onError(r -> this.throwError(r, String.format("Failure retrieving active domain profile by name [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        if (response.isEmpty()) {
            throw ApiNotFoundException.notFound((String)"The specified domain does not exist.", (String[])new String[0]);
        }
        if (response.getSize() > 1) {
            throw ApiNotFoundException.notFound((String)("Multiple domain profiles found with name " + domainName), (String[])new String[0]);
        }
        return (DomainProfileEntity)response.getFirstEntity();
    }

    public DomainSummary fetchSummary(String domainName) {
        DomainProfileEntity domainProfile = this.findByDomainName(domainName);
        CouchDatabase notificationDb = this.notificationDb(domainProfile);
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)"Summary", (String)"TopicInfo").includeDocs(false).group(true).build();
        GetDocumentResponse response = notificationDb.get().document(viewQuery).onError(r -> this.throwError(r, String.format("Failure retrieving topic info for summary [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        ArrayList<TopicInfo> topics = new ArrayList<TopicInfo>();
        List documents = response.getDocumentList();
        for (TextDocument document : documents) {
            String key = document.getKey().getJsonValue().replaceAll("\"", "");
            TopicInfo topicInfo = new TopicInfo(key, document.getContentAsLong().longValue());
            topics.add(topicInfo);
        }
        viewQuery = CouchViewQuery.builder((String)"Summary", (String)"TraitInfo").includeDocs(false).group(true).build();
        response = notificationDb.get().document(viewQuery).onError(r -> this.throwError(r, String.format("Failure retrieving trait info for summary [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        if (response.isError()) {
            throw ApiException.fromCode((int)response.getHttpStatusCode(), (String)("Error reading topic info" + response.getErrorContent().getError()), (String[])new String[0]);
        }
        ArrayList<TraitInfo> traits = new ArrayList<TraitInfo>();
        documents = response.getDocumentList();
        for (TextDocument document : documents) {
            String key = document.getKey().getJsonValue().replaceAll("\"", "");
            TraitInfo traitInfo = new TraitInfo(key, document.getContentAsLong().longValue());
            traits.add(traitInfo);
        }
        return new DomainSummary(topics, traits);
    }

    public QueryResult<DomainProfileEntity> queryActive() {
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)"DomainProfile", (String)"ByDomainStatus").key(new Object[]{"ACTIVE"}).build();
        GetEntityResponse response = this.couchDatabase.get().entity(DomainProfileEntity.class, viewQuery).onError(r -> this.throwError(r, String.format("Failure retrieving active domain profiles [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        return ListQueryResult.newComplete(DomainProfileEntity.class, (Collection)response.getEntityList());
    }

    public QueryResult<DomainProfileEntity> queryAll() {
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)"DomainProfile", (String)"ByDomainStatus").build();
        GetEntityResponse response = this.couchDatabase.get().entity(DomainProfileEntity.class, viewQuery).onError(r -> this.throwError(r, String.format("Failure retrieving active domain profiles [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        return ListQueryResult.newComplete(DomainProfileEntity.class, (Collection)response.getEntityList());
    }

    public DomainProfileEntity createDomain(String domainName, String apiKey, String apiPassword) {
        String notificationDbName = this.couchServers.buildNotificationDbName(domainName);
        String requestDbName = this.couchServers.buildRequestDbName(domainName);
        DomainProfileEntity profileEntity = DomainProfileEntity.newEntity(domainName, apiKey, apiPassword, notificationDbName, requestDbName, RouteCatalog.newEmptyCatalog());
        profileEntity = this.save(profileEntity);
        this.createNotifyDatabase(profileEntity);
        this.createRequestDatabase(profileEntity);
        return profileEntity;
    }

    public DomainProfileEntity save(DomainProfileEntity profileEntity) {
        this.couchDatabase.put().entity((Object)profileEntity).onError(r -> this.throwError(r, String.format("Failure storing domain profile in couch [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        return this.findByProfileId(profileEntity.getProfileId());
    }

    public DomainProfile recreateDomain(String domainName, String apiKey, String apiPassword) {
        if (!this.couchServers.getEnvironment().isTesting()) {
            throw ApiException.badRequest((String)"Can only create domain in test environment", (String[])new String[0]);
        }
        if (this.hasDomain(domainName)) {
            DomainProfileEntity domainProfileEntity = this.findByDomainName(domainName);
            this.deleteDomain(domainProfileEntity);
        }
        DomainProfileEntity domainProfile = this.createDomain(domainName, apiKey, apiPassword);
        return domainProfile.toModel();
    }

    public void deleteDomain(DomainProfileEntity domainProfile) {
        this.couchDatabase.delete().entity((Object)domainProfile).onError(r -> log.error(String.format("Failure deleting domain %s from master db [%s] - %s", domainProfile.getDomainName(), r.getHttpStatus(), r.getErrorReason()))).execute();
        this.couchServers.deleteDomainDatabases(domainProfile.getDomainName());
    }

    private void createNotifyDatabase(DomainProfileEntity domainProfile) {
        String[] designNames;
        CouchDatabase couchDatabase = this.notificationDb(domainProfile);
        WriteResponse createResponse = couchDatabase.createDatabase();
        if (createResponse.isError()) {
            String msg = String.format("Error creating notify couch database [%s] - %s", domainProfile.getNotificationDbName(), createResponse.getErrorReason());
            throw ApiException.internalServerError((String)msg, (String[])new String[0]);
        }
        for (String designName : designNames = new String[]{"Entity", "Notification", "Task", "Summary"}) {
            String designPath = String.format("/couch/%s-design.json", designName);
            InputStream designStream = this.getClass().getResourceAsStream(designPath);
            if (designStream == null) {
                String msg = String.format("Unable to find couch design file at: %s", designPath);
                throw ApiException.internalServerError((String)msg, (String[])new String[0]);
            }
            try {
                String designContent = IoUtils.toString((InputStream)designStream);
                WriteResponse response = couchDatabase.put().design(designName, designContent).execute();
                if (!response.isError()) continue;
                String msg = String.format("Error creating views %s - %s", response.getHttpStatus(), response.getErrorReason());
                throw ApiException.internalServerError((String)msg, (String[])new String[0]);
            }
            catch (IOException ex) {
                String msg = "Error reading design file: " + designPath;
                throw ApiException.internalServerError((Throwable)ex, (String[])new String[]{msg});
            }
        }
    }

    private void createRequestDatabase(DomainProfileEntity domainProfile) {
        String[] designNames;
        CouchDatabase couchDatabase = this.requestDb(domainProfile);
        WriteResponse createResponse = couchDatabase.createDatabase();
        if (createResponse.isError()) {
            String msg = String.format("Error creating request couch database [%s] - %s", domainProfile.getRequestDbName(), createResponse.getErrorReason());
            throw ApiException.internalServerError((String)msg, (String[])new String[0]);
        }
        for (String designName : designNames = new String[]{"Entity", "NotificationRequest"}) {
            String designPath = String.format("/couch/%s-design.json", designName);
            InputStream designStream = this.getClass().getResourceAsStream(designPath);
            if (designStream == null) {
                String msg = String.format("Unable to find design file at: %s", designPath);
                throw ApiException.internalServerError((String)msg, (String[])new String[0]);
            }
            try {
                String designContent = IoUtils.toString((InputStream)designStream);
                WriteResponse response = couchDatabase.put().design(designName, designContent).execute();
                if (!response.isError()) continue;
                String msg = String.format("Error creating views %s - %s", response.getHttpStatus(), response.getErrorReason());
                throw ApiException.internalServerError((String)msg, (String[])new String[0]);
            }
            catch (IOException ex) {
                String msg = "Error reading design file: " + designPath;
                throw ApiException.internalServerError((String)msg, (String[])new String[0]);
            }
        }
        CouchServersConfig serversConfig = this.couchServers.getServersConfig();
        ClientConfig httpClientConfig = new ClientConfig();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)httpClientConfig);
        Client client = clientBuilder.build();
        client.register((Object)HttpAuthenticationFeature.basic((String)serversConfig.getRequestUsername(), (String)serversConfig.getRequestPassword()));
        String documentId = "org.couchdb.user:" + domainProfile.getApiKey();
        String couchBaseUrl = serversConfig.getRequestUrl();
        Response response = client.target(couchBaseUrl).path("_users/" + documentId).request().get();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode.isNotFound()) {
            String userJson = String.format(USER_JSON_TEMPLATE, documentId, domainProfile.getApiKey(), domainProfile.getApiPassword());
            response = client.target(couchBaseUrl).path("_users/" + documentId).request().put(Entity.entity((Object)userJson, (MediaType)MediaType.WILDCARD_TYPE));
            statusCode = HttpStatusCode.findByCode((int)response.getStatus());
            if (statusCode.isError()) {
                throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Error adding user: " + (String)response.readEntity(String.class)), (String[])new String[0]);
            }
        }
    }

    public CouchDatabase requestDb(DomainProfile domainProfile) {
        return this.requestCouchServer.database(domainProfile.getRequestDbName());
    }

    public CouchDatabase notificationDb(DomainProfile domainProfile) {
        return this.notificationCouchServer.database(domainProfile.getNotificationDbName());
    }

    private CouchDatabase requestDb(DomainProfileEntity domainProfile) {
        return this.requestCouchServer.database(domainProfile.getRequestDbName());
    }

    private CouchDatabase notificationDb(DomainProfileEntity domainProfile) {
        return this.notificationCouchServer.database(domainProfile.getNotificationDbName());
    }

    private CouchDatabase requestDb(DomainProfileEntity domainProfile, CouchFeatureSet featureSet) {
        return this.requestCouchServer.database(domainProfile.getRequestDbName(), featureSet);
    }

    private CouchDatabase notificationDb(DomainProfileEntity domainProfile, CouchFeatureSet featureSet) {
        return this.notificationCouchServer.database(domainProfile.getNotificationDbName(), featureSet);
    }
}

