/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.notify.kernel.task.CreateTask;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.task.Task;
import org.tiogasolutions.notify.pub.task.TaskRef;
import org.tiogasolutions.notify.pub.task.TaskResponse;
import org.tiogasolutions.notify.pub.task.TaskStatus;

@CouchEntity(value="Task")
public class TaskEntity {
    protected String taskId;
    protected TaskStatus taskStatus;
    protected String revision;
    protected String notificationId;
    protected ZonedDateTime createdAt;
    protected Destination destination;
    protected TaskResponse lastResponse;

    public static TaskEntity newEntity(CreateTask create) {
        return new TaskEntity(TimeUuid.randomUUID().toString(), null, TaskStatus.PENDING, create.getNotificationId(), ZonedDateTime.now(), create.getDestination(), null);
    }

    @JsonCreator
    private TaskEntity(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="revision") String revision, @JsonProperty(value="taskStatus") TaskStatus taskStatus, @JsonProperty(value="notificationId") String notificationId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="destination") Destination destination, @JsonProperty(value="lastResponse") TaskResponse lastResponse) {
        this.taskId = taskId;
        this.revision = revision;
        this.taskStatus = taskStatus;
        this.notificationId = notificationId;
        this.createdAt = createdAt;
        this.destination = destination;
        this.lastResponse = lastResponse;
    }

    public Task toTask() {
        return new Task(null, this.taskId, this.revision, this.taskStatus, this.notificationId, this.createdAt, this.destination, this.lastResponse);
    }

    @CouchId
    public final String getTaskId() {
        return this.taskId;
    }

    @CouchRevision
    public final String getRevision() {
        return this.revision;
    }

    public final TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public final String getNotificationId() {
        return this.notificationId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public final TaskEntity pending() {
        this.taskStatus = TaskStatus.PENDING;
        return this;
    }

    public final TaskEntity sending() {
        this.taskStatus = TaskStatus.SENDING;
        return this;
    }

    public final void response(TaskResponse response) {
        this.lastResponse = response;
        switch (response.getResponseAction()) {
            case RETRY: {
                break;
            }
            case COMPLETE: {
                this.taskStatus = TaskStatus.COMPLETED;
                break;
            }
            case FAIL: {
                this.taskStatus = TaskStatus.FAILED;
            }
        }
    }

    public TaskResponse getLastResponse() {
        return this.lastResponse;
    }

    public TaskRef toTaskRef() {
        return new TaskRef(this.taskId, this.revision, this.notificationId);
    }

    @JsonIgnore
    public String getLabel() {
        ArrayList<String> argValues = new ArrayList<String>();
        for (String value : this.destination.getArguments().values()) {
            argValues.add(value);
        }
        return String.format("Task %s: %s %s", this.taskId, this.destination.getProvider(), argValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskEntity that = (TaskEntity)o;
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals((Object)that.destination) : that.destination != null) {
            return false;
        }
        if (this.lastResponse != null ? !this.lastResponse.equals((Object)that.lastResponse) : that.lastResponse != null) {
            return false;
        }
        if (this.notificationId != null ? !this.notificationId.equals(that.notificationId) : that.notificationId != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.taskId != null ? !this.taskId.equals(that.taskId) : that.taskId != null) {
            return false;
        }
        return this.taskStatus == that.taskStatus;
    }

    public int hashCode() {
        int result = this.taskId != null ? this.taskId.hashCode() : 0;
        result = 31 * result + (this.taskStatus != null ? this.taskStatus.hashCode() : 0);
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.notificationId != null ? this.notificationId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        result = 31 * result + (this.lastResponse != null ? this.lastResponse.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TaskEntity{taskId='" + this.taskId + '\'' + ", taskStatus=" + this.taskStatus + ", revision='" + this.revision + '\'' + ", notificationId='" + this.notificationId + '\'' + ", createdAt=" + this.createdAt + ", destination=" + this.destination + ", lastResponse=" + this.lastResponse + '}';
    }
}

