/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.execution;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionAccessor;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.receiver.ReceiverExecutor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorExecutor;
import org.tiogasolutions.notify.pub.domain.DomainProfile;

@Component
public class ExecutionManager
implements ExecutionAccessor {
    private final EventBus eventBus;
    private final DomainKernel domainKernel;
    private final NotificationKernel notificationKernel;
    private final ObjectMapper objectMapper;
    private final ThreadLocal<ExecutionContext> threadLocal = new ThreadLocal();
    private final ReceiverExecutor receiverExecutor;
    private final TaskProcessorExecutor processorExecutor;

    @Autowired
    public ExecutionManager(EventBus eventBus, DomainKernel domainKernel, NotificationKernel notificationKernel, ReceiverExecutor receiverExecutor, TaskProcessorExecutor processorExecutor, ObjectMapper objectMapper) {
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.receiverExecutor = receiverExecutor;
        this.processorExecutor = processorExecutor;
        this.notificationKernel = notificationKernel;
        this.objectMapper = objectMapper;
    }

    public void clearContext() {
        this.threadLocal.remove();
    }

    public ReceiverExecutor getReceiverExecutor() {
        return this.receiverExecutor;
    }

    public TaskProcessorExecutor getProcessorExecutor() {
        return this.processorExecutor;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public DomainKernel getDomainKernel() {
        return this.domainKernel;
    }

    public NotificationKernel getNotificationKernel() {
        return this.notificationKernel;
    }

    public ExecutionContext newSystemContext() {
        ExecutionContext context = new ExecutionContext(this.domainKernel.getSystemDomain());
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newSystemContext(UriInfo uriInfo, HttpHeaders httpHeaders) {
        ExecutionContext context = new ExecutionContext(this.domainKernel.getSystemDomain(), uriInfo, httpHeaders);
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newApiContext(String apiKey, UriInfo uriInfo, HttpHeaders httpHeaders) {
        DomainProfile domainProfile = this.domainKernel.findByApiKey(apiKey);
        ExecutionContext context = new ExecutionContext(domainProfile, uriInfo, httpHeaders);
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newApiContext(DomainProfile domainProfile, UriInfo uriInfo, HttpHeaders httpHeaders) {
        ExecutionContext context = new ExecutionContext(domainProfile, uriInfo, httpHeaders);
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newApiContext(String apiKey) {
        DomainProfile domainProfile = this.domainKernel.findByApiKey(apiKey);
        ExecutionContext context = new ExecutionContext(domainProfile);
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newApiContext(DomainProfile domainProfile) {
        ExecutionContext context = new ExecutionContext(domainProfile);
        this.assignContext(context);
        return context;
    }

    public void assignContext(ExecutionContext context) {
        this.threadLocal.set(context);
    }

    @Override
    public boolean hasContext() {
        return this.threadLocal.get() != null;
    }

    @Override
    public ExecutionContext context() {
        ExecutionContext context = this.threadLocal.get();
        if (context == null) {
            throw ApiException.internalServerError((String)"There is no current execution context for this thread.", (String[])new String[0]);
        }
        return context;
    }

    @Override
    public String domainName() {
        return this.context().getDomainName();
    }
}

