/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.message;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.Context;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.lib.thymeleaf.ThymeleafFactory;
import org.tiogasolutions.notify.kernel.message.HtmlMessage;
import org.tiogasolutions.notify.kernel.message.MessageModel;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.task.Task;

public class ThymeleafMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(ThymeleafMessageBuilder.class);
    private ThymeleafFactory thymeleafFactory;
    private static Map<String, String> escapeMap = new HashMap<String, String>();

    public ThymeleafMessageBuilder() {
        this.thymeleafFactory = new ThymeleafFactory();
    }

    public ThymeleafMessageBuilder(ThymeleafFactory thymeleafFactory) {
        this.thymeleafFactory = thymeleafFactory;
    }

    public String createMessage(DomainProfile domainProfile, Notification notification, Task task, String templatePath) {
        Context context = new Context();
        context.setVariable("it", (Object)new MessageModel(domainProfile, notification, task));
        String text = this.thymeleafFactory.process(templatePath, context);
        if (log.isTraceEnabled()) {
            log.trace("Text after Thymeleaf processing: " + text);
        }
        text = this.decodeHtml(text);
        if (log.isTraceEnabled()) {
            log.trace("Text after decodeHTML: " + text);
        }
        return text;
    }

    private String decodeHtml(String text) {
        for (Map.Entry<String, String> entry : escapeMap.entrySet()) {
            text = text.replaceAll(entry.getKey(), entry.getValue());
        }
        return text;
    }

    public HtmlMessage createHtmlMessage(DomainProfile domainProfile, Notification notification, Task task, String templatePath) {
        String htmlContent = this.createHtmlContent(domainProfile, notification, task, templatePath);
        return new HtmlMessage(htmlContent);
    }

    public String createHtmlContent(DomainProfile domainProfile, Notification notification, Task task, String templatePath) {
        Context context = new Context();
        context.setVariable("it", (Object)new MessageModel(domainProfile, notification, task));
        return this.thymeleafFactory.process(templatePath, context);
    }

    public String getEmailTemplatePath(Map<String, String> argMap, String propertyName) {
        return this.getTemplatePath(argMap, propertyName, "classpath:/notify-kernel/default-email-template.html");
    }

    public String getTemplatePath(Map<String, String> argMap, String propertyName, String defaultPath) {
        String templatePath = argMap.get(propertyName);
        if (StringUtils.isBlank((Object)templatePath)) {
            templatePath = defaultPath;
        }
        return templatePath;
    }

    private static void register(String utf, String code) {
        escapeMap.put("&" + code + ";", utf);
    }

    static {
        ThymeleafMessageBuilder.register("\"", "quot");
        ThymeleafMessageBuilder.register("&", "amp");
        ThymeleafMessageBuilder.register("<", "lt");
        ThymeleafMessageBuilder.register(">", "gt");
        ThymeleafMessageBuilder.register("\u00a0", "nbsp");
        ThymeleafMessageBuilder.register("\u00a1", "iexcl");
        ThymeleafMessageBuilder.register("\u00a2", "cent");
        ThymeleafMessageBuilder.register("\u00a3", "pound");
        ThymeleafMessageBuilder.register("\u00a4", "curren");
        ThymeleafMessageBuilder.register("\u00a5", "yen");
        ThymeleafMessageBuilder.register("\u00a6", "brvbar");
        ThymeleafMessageBuilder.register("\u00a7", "sect");
        ThymeleafMessageBuilder.register("\u00a8", "uml");
        ThymeleafMessageBuilder.register("\u00a9", "copy");
        ThymeleafMessageBuilder.register("\u00aa", "ordf");
        ThymeleafMessageBuilder.register("\u00ab", "laquo");
        ThymeleafMessageBuilder.register("\u00ac", "not");
        ThymeleafMessageBuilder.register("\u00ad", "shy");
        ThymeleafMessageBuilder.register("\u00ae", "reg");
        ThymeleafMessageBuilder.register("\u00af", "macr");
        ThymeleafMessageBuilder.register("\u00b0", "deg");
        ThymeleafMessageBuilder.register("\u00b1", "plusmn");
        ThymeleafMessageBuilder.register("\u00b2", "sup2");
        ThymeleafMessageBuilder.register("\u00b3", "sup3");
        ThymeleafMessageBuilder.register("\u00b4", "acute");
        ThymeleafMessageBuilder.register("\u00b5", "micro");
        ThymeleafMessageBuilder.register("\u00b6", "para");
        ThymeleafMessageBuilder.register("\u00b7", "middot");
        ThymeleafMessageBuilder.register("\u00b8", "cedil");
        ThymeleafMessageBuilder.register("\u00b9", "sup1");
        ThymeleafMessageBuilder.register("\u00ba", "ordm");
        ThymeleafMessageBuilder.register("\u00bb", "raquo");
        ThymeleafMessageBuilder.register("\u00bc", "frac14");
        ThymeleafMessageBuilder.register("\u00bd", "frac12");
        ThymeleafMessageBuilder.register("\u00be", "frac34");
        ThymeleafMessageBuilder.register("\u00bf", "iquest");
        ThymeleafMessageBuilder.register("\u00c0", "Agrave");
        ThymeleafMessageBuilder.register("\u00c1", "Aacute");
        ThymeleafMessageBuilder.register("\u00c2", "Acirc");
        ThymeleafMessageBuilder.register("\u00c3", "Atilde");
        ThymeleafMessageBuilder.register("\u00c4", "Auml");
        ThymeleafMessageBuilder.register("\u00c5", "Aring");
        ThymeleafMessageBuilder.register("\u00c6", "AElig");
        ThymeleafMessageBuilder.register("\u00c7", "Ccedil");
        ThymeleafMessageBuilder.register("\u00c8", "Egrave");
        ThymeleafMessageBuilder.register("\u00c9", "Eacute");
        ThymeleafMessageBuilder.register("\u00ca", "Ecirc");
        ThymeleafMessageBuilder.register("\u00cb", "Euml");
        ThymeleafMessageBuilder.register("\u00cc", "Igrave");
        ThymeleafMessageBuilder.register("\u00cd", "Iacute");
        ThymeleafMessageBuilder.register("\u00ce", "Icirc");
        ThymeleafMessageBuilder.register("\u00cf", "Iuml");
        ThymeleafMessageBuilder.register("\u00d0", "ETH");
        ThymeleafMessageBuilder.register("\u00d1", "Ntilde");
        ThymeleafMessageBuilder.register("\u00d2", "Ograve");
        ThymeleafMessageBuilder.register("\u00d3", "Oacute");
        ThymeleafMessageBuilder.register("\u00d4", "Ocirc");
        ThymeleafMessageBuilder.register("\u00d5", "Otilde");
        ThymeleafMessageBuilder.register("\u00d6", "Ouml");
        ThymeleafMessageBuilder.register("\u00d7", "times");
        ThymeleafMessageBuilder.register("\u00d8", "Oslash");
        ThymeleafMessageBuilder.register("\u00d9", "Ugrave");
        ThymeleafMessageBuilder.register("\u00da", "Uacute");
        ThymeleafMessageBuilder.register("\u00db", "Ucirc");
        ThymeleafMessageBuilder.register("\u00dc", "Uuml");
        ThymeleafMessageBuilder.register("\u00dd", "Yacute");
        ThymeleafMessageBuilder.register("\u00de", "THORN");
        ThymeleafMessageBuilder.register("\u00df", "szlig");
        ThymeleafMessageBuilder.register("\u00e0", "agrave");
        ThymeleafMessageBuilder.register("\u00e1", "aacute");
        ThymeleafMessageBuilder.register("\u00e2", "acirc");
        ThymeleafMessageBuilder.register("\u00e3", "atilde");
        ThymeleafMessageBuilder.register("\u00e4", "auml");
        ThymeleafMessageBuilder.register("\u00e5", "aring");
        ThymeleafMessageBuilder.register("\u00e6", "aelig");
        ThymeleafMessageBuilder.register("\u00e7", "ccedil");
        ThymeleafMessageBuilder.register("\u00e8", "egrave");
        ThymeleafMessageBuilder.register("\u00e9", "eacute");
        ThymeleafMessageBuilder.register("\u00ea", "ecirc");
        ThymeleafMessageBuilder.register("\u00eb", "euml");
        ThymeleafMessageBuilder.register("\u00ec", "igrave");
        ThymeleafMessageBuilder.register("\u00ed", "iacute");
        ThymeleafMessageBuilder.register("\u00ee", "icirc");
        ThymeleafMessageBuilder.register("\u00ef", "iuml");
        ThymeleafMessageBuilder.register("\u00f0", "eth");
        ThymeleafMessageBuilder.register("\u00f1", "ntilde");
        ThymeleafMessageBuilder.register("\u00f2", "ograve");
        ThymeleafMessageBuilder.register("\u00f3", "oacute");
        ThymeleafMessageBuilder.register("\u00f4", "ocirc");
        ThymeleafMessageBuilder.register("\u00f5", "otilde");
        ThymeleafMessageBuilder.register("\u00f6", "ouml");
        ThymeleafMessageBuilder.register("\u00f7", "divide");
        ThymeleafMessageBuilder.register("\u00f8", "oslash");
        ThymeleafMessageBuilder.register("\u00f9", "ugrave");
        ThymeleafMessageBuilder.register("\u00fa", "uacute");
        ThymeleafMessageBuilder.register("\u00fb", "ucirc");
        ThymeleafMessageBuilder.register("\u00fc", "uuml");
        ThymeleafMessageBuilder.register("\u00fd", "yacute");
        ThymeleafMessageBuilder.register("\u00fe", "thorn");
        ThymeleafMessageBuilder.register("\u00ff", "yuml");
    }
}

