/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.internal.util;

import java.net.URI;

public class UriUtil {
    public static String lastPathElement(URI uri) {
        if (uri == null) {
            return null;
        }
        return UriUtil.lastPathElement(uri.getPath());
    }

    public static String lastPathElement(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(47);
        if (index >= 0) {
            return path.substring(index + 1);
        }
        return null;
    }

    public static String buildPath(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (path == null) {
                throw new IllegalArgumentException("Attempting to build path with null element, path so far is: " + sb.toString());
            }
            sb.append("/");
            sb.append(path);
        }
        return sb.toString();
    }

    public static String buildPathIgnoreNull(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (path == null) continue;
            sb.append("/");
            sb.append(path);
        }
        return sb.toString();
    }
}

