/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.tiogasolutions.notify.engine.AppResource;
import org.tiogasolutions.notify.engine.v2.AdminResourceV2;
import org.tiogasolutions.notify.engine.v2.ClientResourceV2;
import org.tiogasolutions.notify.engine.web.SystemStatus;
import org.tiogasolutions.notify.engine.web.readers.StaticContentReader;
import org.tiogasolutions.notify.kernel.PubUtils;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;

@Path(value="/")
@Scope(value="prototype")
public class RootResource {
    private static final Logger log = LoggerFactory.getLogger(RootResource.class);
    @Context
    UriInfo uriInfo;
    @Autowired
    private ExecutionManager em;
    @Autowired
    private StaticContentReader staticContentReader;

    @GET
    @Produces(value={"text/html"})
    public String getIndexHtml() throws IOException {
        try {
            Attributes attributes = this.getManifest().getMainAttributes();
            String version = attributes.getValue("Implementation-Version");
            String build = attributes.getValue("Build-Number");
            String timestamp = attributes.getValue("Build-Timestamp");
            return String.format("<html><body><h1>Notify Server</h1><div>Build-Number: %s</div><div>Build-Timestamp: %s</div><div>Implementation-Version: %s</div></body></html>", build, timestamp, version);
        }
        catch (Exception e) {
            return String.format("<html><body><h1>Notify Server</h1><div>%s</div></body></html>", e.getMessage());
        }
    }

    private Manifest getManifest() throws IOException {
        Enumeration<URL> resources = RootResource.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            try {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                String moduleName = manifest.getMainAttributes().getValue("Module-Name");
                if (!"tioga-notify-server-grizzly".equalsIgnoreCase(moduleName)) continue;
                return manifest;
            }
            catch (IOException iOException) {
            }
        }
        throw new IOException("Manifest not found.");
    }

    @GET
    @Path(value="/health-check")
    @Produces(value={"text/html"})
    public Response healthCheck$GET() {
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="/app")
    public AppResource getAppResource() {
        return new AppResource(this.staticContentReader, this.uriInfo);
    }

    @Path(value="/api/v2")
    public ClientResourceV2 getClientResource() {
        return new ClientResourceV2(this.em);
    }

    @Path(value="/api/v2/admin")
    public AdminResourceV2 getAdminResource() {
        return new AdminResourceV2(this.newPubUtils(), this.em);
    }

    private PubUtils newPubUtils() {
        return new PubUtils(this.uriInfo);
    }

    @GET
    @Path(value="/api/v2/status")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public SystemStatus getStatus() {
        return new SystemStatus(this.em.getReceiverExecutor().getExecutorStatus(), this.em.getProcessorExecutor().getExecutorStatus());
    }
}

