/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.lib.hal.HalItem;
import org.tiogasolutions.lib.hal.HalLinks;
import org.tiogasolutions.lib.hal.HalLinksBuilder;
import org.tiogasolutions.notify.engine.v2.NotificationRequestResourceV2;
import org.tiogasolutions.notify.engine.v2.NotificationsResourceV2;
import org.tiogasolutions.notify.engine.v2.RouteCatalogResourceV2;
import org.tiogasolutions.notify.engine.v2.TasksResourceV2;
import org.tiogasolutions.notify.kernel.PubUtils;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.domain.DomainSummary;

public class AdminDomainResourceV2 {
    private final PubUtils pubUtils;
    private final ExecutionManager em;
    private final String domainName;

    public AdminDomainResourceV2(PubUtils pubUtils, ExecutionManager em, String domainName) {
        this.pubUtils = pubUtils;
        this.em = em;
        this.domainName = domainName;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDomainProfile() {
        DomainProfile domainProfile = this.em.getDomainKernel().findByDomainName(this.domainName);
        HalItem item = this.pubUtils.fromDomainProfile(HttpStatusCode.CREATED, domainProfile);
        return this.pubUtils.toResponse(item).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteDomain() {
        this.em.getDomainKernel().deleteDomain(this.domainName);
        HalLinks links = HalLinksBuilder.builder().create("domains", this.pubUtils.uriAdminDomains()).build();
        HalItem item = new HalItem(HttpStatusCode.OK, links);
        return this.pubUtils.toResponse(item).build();
    }

    @GET
    @Path(value="/summary")
    @Produces(value={"application/json"})
    public Response getDomainSummary() {
        DomainSummary summary = this.em.getDomainKernel().fetchSummary(this.domainName);
        return Response.ok((Object)summary).build();
    }

    @Path(value="/notifications")
    public NotificationsResourceV2 getNotificationsResourceV1(@Context Request request) {
        DomainProfile domainProfile = this.em.getDomainKernel().findByDomainName(this.domainName);
        this.em.newApiContext(domainProfile);
        return new NotificationsResourceV2(request, this.em);
    }

    @Path(value="/route-catalog")
    public RouteCatalogResourceV2 getRouteCatalogResourceV1() {
        DomainProfile domainProfile = this.em.getDomainKernel().findByDomainName(this.domainName);
        this.em.newApiContext(domainProfile);
        return new RouteCatalogResourceV2(this.em);
    }

    @Path(value="/requests")
    public NotificationRequestResourceV2 getRequestResourceV1() {
        DomainProfile domainProfile = this.em.getDomainKernel().findByDomainName(this.domainName);
        this.em.newApiContext(domainProfile);
        return new NotificationRequestResourceV2(this.em);
    }

    @Path(value="/tasks")
    public TasksResourceV2 getTasksResourceV1() {
        DomainProfile domainProfile = this.em.getDomainKernel().findByDomainName(this.domainName);
        this.em.newApiContext(domainProfile);
        return new TasksResourceV2(this.em);
    }
}

