/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.web;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tiogasolutions.notify.kernel.config.SystemConfiguration;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;

@Provider
@PreMatching
@Priority(value=5000)
public class EngineResponseFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(EngineResponseFilter.class);
    @Autowired
    private ExecutionManager executionManager;
    @Autowired
    private SystemConfiguration systemConfiguration;

    public EngineResponseFilter() {
        log.info("Created");
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        this.executionManager.clearContext();
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)this.systemConfiguration.getAccessControlAllowOrigin());
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"Accept, Content-Type, Authorization, Access-Control-Allow-Origin");
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, DELETE, PUT, POST");
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
    }
}

