/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.hal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.lib.hal.HalLink;
import org.tiogasolutions.lib.hal.HalLinks;

@JsonPropertyOrder(value={"_response", "_links"})
public class HalItem {
    @JsonIgnore
    private final HttpStatusCode httpStatusCode;
    private final HalLinks _links;

    @JsonCreator
    protected HalItem(@JsonProperty(value="_links") HalLinks _links) {
        this.httpStatusCode = HttpStatusCode.UNDEFINED;
        this._links = _links != null ? _links : HalLinks.empty();
    }

    public HalItem(int code) {
        this(HttpStatusCode.findByCode((int)code), HalLinks.empty());
    }

    public HalItem(int code, HalLinks _links) {
        this(HttpStatusCode.findByCode((int)code), _links);
    }

    public HalItem(HttpStatusCode statusCode) {
        this(statusCode, HalLinks.empty());
    }

    public HalItem(HttpStatusCode statusCode, HalLinks _links) {
        this.httpStatusCode = statusCode;
        this._links = _links != null ? _links : HalLinks.empty();
    }

    public HttpStatusCode getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public HalLinks get_links() {
        return this._links;
    }

    public HalLink getLink(String rel) {
        return this._links.getLink(rel);
    }
}

