/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.smtp;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.tiogasolutions.dev.domain.comm.AuthenticationMethod;
import org.tiogasolutions.notify.kernel.message.HtmlMessage;
import org.tiogasolutions.notify.kernel.message.ThymeleafMessageBuilder;
import org.tiogasolutions.notify.kernel.task.TaskProcessor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorType;
import org.tiogasolutions.notify.processor.smtp.EmailMessage;
import org.tiogasolutions.notify.processor.smtp.SmtpAuthType;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.task.Task;
import org.tiogasolutions.notify.pub.task.TaskResponse;

@Component
public class SmtpTaskProcessor
implements TaskProcessor {
    private static final TaskProcessorType PROCESSOR_TYPE = new TaskProcessorType("smtp");
    private final ThymeleafMessageBuilder messageBuilder = new ThymeleafMessageBuilder();

    public boolean isReady() {
        return true;
    }

    public TaskResponse processTask(DomainProfile domainProfile, Notification notification, Task task) {
        Map argMap = task.getDestination().getArguments();
        String templatePath = this.messageBuilder.getEmailTemplatePath(argMap, "templatePath");
        HtmlMessage htmlMessage = this.messageBuilder.createHtmlMessage(domainProfile, notification, task, templatePath);
        EmailMessage emailMessage = this.createEmailMessage(argMap);
        emailMessage.send(htmlMessage.getSubject(), null, htmlMessage.getBody(), new File[0]);
        return TaskResponse.complete((String)"Email sent");
    }

    protected EmailMessage createEmailMessage(Map<String, String> argMap) {
        SmtpAuthType authType = SmtpAuthType.valueOf(argMap.get("smtpAuthType"));
        String host = argMap.get("smtpHost");
        String port = argMap.get("smtpPort");
        String username = argMap.get("smtpUsername");
        String password = argMap.get("smtpPassword");
        String from = argMap.get("smtpFrom");
        String recipient = argMap.get("smtpRecipients");
        EmailMessage message = new EmailMessage(host, port, Collections.singletonList(recipient));
        message.setFrom(from);
        if (authType.isTls()) {
            message.setAuthentication(AuthenticationMethod.TLS, username, password);
        } else if (authType.isSsl()) {
            message.setAuthentication(AuthenticationMethod.SSL, username, password);
        } else {
            message.setAuthentication(AuthenticationMethod.NONE, username, password);
        }
        return message;
    }

    public TaskProcessorType getType() {
        return PROCESSOR_TYPE;
    }
}

