/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.push;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.UnsupportedMethodException;
import org.tiogasolutions.notify.kernel.message.HtmlMessage;
import org.tiogasolutions.notify.kernel.message.ThymeleafMessageBuilder;
import org.tiogasolutions.notify.kernel.task.TaskProcessor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorType;
import org.tiogasolutions.notify.processor.push.PushClientFactory;
import org.tiogasolutions.notify.processor.push.PushDestinationType;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.task.Task;
import org.tiogasolutions.notify.pub.task.TaskResponse;
import org.tiogasolutions.push.client.PushServerClient;
import org.tiogasolutions.push.pub.SesEmailPush;
import org.tiogasolutions.push.pub.SmtpEmailPush;
import org.tiogasolutions.push.pub.TwilioSmsPush;
import org.tiogasolutions.push.pub.XmppPush;
import org.tiogasolutions.push.pub.common.Push;

@Component
public class PushTaskProcessor
implements TaskProcessor {
    private static final Logger log = LoggerFactory.getLogger(PushTaskProcessor.class);
    private static final TaskProcessorType PROCESSOR_TYPE = new TaskProcessorType("push");
    private final PushClientFactory factory;
    private final ThymeleafMessageBuilder messageBuilder;

    @Autowired
    public PushTaskProcessor(PushClientFactory factory) {
        this.factory = factory;
        this.messageBuilder = new ThymeleafMessageBuilder();
    }

    public TaskProcessorType getType() {
        return PROCESSOR_TYPE;
    }

    public boolean isReady() {
        return true;
    }

    public TaskResponse processTask(DomainProfile domainProfile, Notification notification, Task task) {
        List<Push> pushList;
        log.debug("Processing task: " + task);
        Destination destination = task.getDestination();
        Map argMap = destination.getArguments();
        String url = (String)argMap.get("url");
        if (StringUtils.isBlank((Object)url)) {
            throw ApiException.badRequest((String)"Task given to push processor which does specify the \"url\" of the push server.", (String[])new String[0]);
        }
        PushServerClient client = this.factory.createPushServerClient(url);
        String type = (String)argMap.get("type");
        if (StringUtils.isBlank((Object)type)) {
            throw ApiException.badRequest((String)"Task given to push processor which does specify the \"type\" of push.", (String[])new String[0]);
        }
        List<String> recipients = this.readRecipients(argMap);
        if (recipients.isEmpty()) {
            throw ApiException.badRequest((String)"Task given to push processor which does not have any \"recipients\".", (String[])new String[0]);
        }
        String from = (String)argMap.get("from");
        if (StringUtils.isBlank((Object)from)) {
            throw ApiException.badRequest((String)"Task given to push processor which does not have a \"from\" indicator.", (String[])new String[0]);
        }
        PushDestinationType destinationType = PushDestinationType.valueOf(type);
        if (destinationType.isSmsMsg()) {
            pushList = this.toSmsPush(notification, from, recipients);
        } else if (destinationType.isJabberMsg()) {
            pushList = this.toJabber(notification, recipients);
        } else if (destinationType.isSesEmailMsg()) {
            pushList = this.toSesEmailPush(domainProfile, notification, task, argMap, from, recipients);
        } else if (destinationType.isSmtpEmailMsg()) {
            pushList = this.toSmtpEmailPush(domainProfile, notification, task, argMap, from, recipients);
        } else if (destinationType.isPhoneCall()) {
            pushList = this.toPhoneCallPush();
        } else {
            String msg = String.format("The task type \"%s\" is not supported.", new Object[]{destinationType});
            throw new UnsupportedOperationException(msg);
        }
        pushList.forEach(arg_0 -> ((PushServerClient)client).send(arg_0));
        return TaskResponse.complete((String)"Ok");
    }

    private List<String> readRecipients(Map<String, String> argMap) {
        ArrayList<String> recipients = new ArrayList<String>();
        if (argMap.containsKey("recipients")) {
            String value = argMap.get("recipients");
            if (value.contains(",")) {
                for (String recipient : StringUtils.tokenize((Object)value, (char)',')) {
                    recipients.add(recipient.trim());
                }
            } else if (value.contains(";")) {
                for (String recipient : StringUtils.tokenize((Object)value, (char)';')) {
                    recipients.add(recipient.trim());
                }
            } else {
                recipients.add(value);
            }
        }
        return recipients;
    }

    private List<Push> toJabber(Notification notification, List<String> recipients) {
        return recipients.stream().map(recipient -> XmppPush.newPush((String)recipient, (String)notification.getSummary(), null, (String[])new String[0])).collect(Collectors.toList());
    }

    private List<Push> toSmsPush(Notification notification, String from, List<String> recipients) {
        return recipients.stream().map(recipient -> TwilioSmsPush.newPush((String)from, (String)recipient, (String)notification.getSummary(), null, (String[])new String[0])).collect(Collectors.toList());
    }

    private List<Push> toPhoneCallPush() {
        throw new UnsupportedMethodException();
    }

    private List<Push> toSesEmailPush(DomainProfile domainProfile, Notification notification, Task task, Map<String, String> argMap, String from, List<String> recipients) {
        String templatePath = this.messageBuilder.getEmailTemplatePath(argMap, "templatePath");
        HtmlMessage message = this.messageBuilder.createHtmlMessage(domainProfile, notification, task, templatePath);
        return recipients.stream().map(recipient -> SesEmailPush.newPush((String)recipient, (String)from, (String)message.getSubject(), (String)message.getBody(), null, (String[])new String[0])).collect(Collectors.toList());
    }

    private List<Push> toSmtpEmailPush(DomainProfile domainProfile, Notification notification, Task task, Map<String, String> argMap, String from, List<String> recipients) {
        String templatePath = this.messageBuilder.getEmailTemplatePath(argMap, "templatePath");
        HtmlMessage message = this.messageBuilder.createHtmlMessage(domainProfile, notification, task, templatePath);
        return recipients.stream().map(recipient -> SmtpEmailPush.newPush((String)recipient, (String)from, (String)message.getSubject(), (String)message.getBody(), null, (String[])new String[0])).collect(Collectors.toList());
    }
}

