/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import ch.qos.logback.classic.Level;
import java.nio.file.Path;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.tiogasolutions.app.common.AppPathResolver;
import org.tiogasolutions.app.common.AppUtils;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.common.LogbackUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.lib.spring.SpringUtils;
import org.tiogasolutions.notify.kernel.config.CouchServersConfig;
import org.tiogasolutions.notify.notifier.Notifier;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.ShutdownUtils;

public class NotifyServer {
    private static final String PREFIX = "notify";
    private static final String APP_NAME = "Notify Engine";
    private static final Logger log = LoggerFactory.getLogger(NotifyServer.class);

    public static void main(String ... args) throws Exception {
        Level level = Level.WARN;
        AppUtils.initLogback((Level)level);
        String levelCode = EnvUtils.findProperty((String)"notify_log_level", (String)level.toString());
        level = Level.toLevel((String)levelCode, null);
        if (StringUtils.isNotBlank((Object)level)) {
            LogbackUtils.setRootLevel((Level)level);
        } else {
            level = Level.WARN;
            log.error("Cannot initialize default log level to \"" + levelCode + "\"");
        }
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])new Class[]{NotifyServer.class});
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])new Class[]{GrizzlyServer.class});
        AppPathResolver resolver = new AppPathResolver("notify_");
        Path runtimeDir = resolver.resolveRuntimePath();
        Path configDir = resolver.resolveConfigDir(runtimeDir);
        Path logbackFile = AppUtils.initLogback((Level)level, (Path)configDir, (String)"notify_log_config", (String)"logback.xml");
        String springConfigPath = resolver.resolveSpringPath(configDir, String.format("classpath:/tioga-%s-server-grizzly/spring-config.xml", PREFIX));
        String[] activeProfiles = resolver.resolveSpringProfiles();
        AbstractXmlApplicationContext applicationContext = SpringUtils.createXmlConfigApplicationContext((String)springConfigPath, (String[])activeProfiles);
        GrizzlyServer grizzlyServer = (GrizzlyServer)applicationContext.getBean(GrizzlyServer.class);
        Notifier notifier = (Notifier)applicationContext.getBean(Notifier.class);
        if (Arrays.asList(args).contains("-shutdown")) {
            String msg = String.format("Shutting down %s at %s:%s", APP_NAME, grizzlyServer.getConfig().getHostName(), grizzlyServer.getConfig().getShutdownPort());
            log.warn(msg);
            notifier.begin().summary(msg).trait("action", (Object)"shutdown").send().get();
            ShutdownUtils.shutdownRemote((GrizzlyServerConfig)grizzlyServer.getConfig());
            System.exit(0);
        } else {
            String logMessage = String.format("Starting %s:\n  *  Runtime Dir     (%s_runtime_dir)     %s\n  *  Config Dir      (%s_config_dir)      %s\n  *  Logback File    (%s_log_config)      %s\n  *  Spring Path     (%s_spring_config)   %s\n  *  Active Profiles (%s_active_profiles) %s", APP_NAME, PREFIX, runtimeDir, PREFIX, configDir, PREFIX, logbackFile, PREFIX, springConfigPath, PREFIX, Arrays.asList(activeProfiles));
            log.info(logMessage);
            GrizzlyServerConfig grizzlyServerConfig = (GrizzlyServerConfig)applicationContext.getBean(GrizzlyServerConfig.class);
            logMessage = String.format("Server config:\n  *  Host Name: %s\n  *  Port: %s\n  *  Shutdown Port: %s\n  *  Context: %s\n  *  Shutdown Timeout: %s", grizzlyServerConfig.getHostName(), grizzlyServerConfig.getPort(), grizzlyServerConfig.getShutdownPort(), grizzlyServerConfig.getContext(), grizzlyServerConfig.getShutdownTimeout());
            log.info(logMessage);
            CouchServersConfig couchServersConfig = (CouchServersConfig)applicationContext.getBean(CouchServersConfig.class);
            logMessage = String.format("Database config:\n  * Master Url: %s\n  * Master Database Name: %s\n  * Notification Url: %s  * Notification Database Prefix: %s\n  * Notification Database Suffix: %s\n  * Request Url: %s\n  * Request Database Prefix: %s\n  * Request Database Suffix: %s", couchServersConfig.getMasterUrl(), couchServersConfig.getMasterDatabaseName(), couchServersConfig.getNotificationUrl(), couchServersConfig.getNotificationDatabasePrefix(), couchServersConfig.getNotificationDatabaseSuffix(), couchServersConfig.getRequestUrl(), couchServersConfig.getRequestDatabasePrefix(), couchServersConfig.getRequestDatabaseSuffix());
            log.info(logMessage);
            notifier.begin().summary("Starting Notify Engine").trait("action", (Object)"startup").trait("notify_runtime_dir", (Object)runtimeDir).trait("notify_config_dir", (Object)configDir).trait("notify_log_config", (Object)logbackFile).trait("notify_spring_config", (Object)springConfigPath).trait("notify_active_profiles", Arrays.asList(activeProfiles)).trait("engine-host-name", (Object)grizzlyServerConfig.getHostName()).trait("engine-port", (Object)grizzlyServerConfig.getPort()).trait("engine-shutdown-port", (Object)grizzlyServerConfig.getShutdownPort()).trait("engine-context", (Object)grizzlyServerConfig.getContext()).trait("engine-shutdown-timeout", (Object)grizzlyServerConfig.getShutdownTimeout()).trait("couch-db-master-url", (Object)couchServersConfig.getMasterUrl()).trait("couch-db-master-database-name", (Object)couchServersConfig.getMasterDatabaseName()).trait("couch-db-notification-url", (Object)couchServersConfig.getNotificationUrl()).trait("couch-db-notification-database-prefix", (Object)couchServersConfig.getNotificationDatabasePrefix()).trait("couch-db-notification-database-suffix", (Object)couchServersConfig.getNotificationDatabaseSuffix()).trait("couch-db-request-url", (Object)couchServersConfig.getRequestUrl()).trait("couch-db-request-database-prefix", (Object)couchServersConfig.getRequestDatabasePrefix()).trait("couch-db-request-database-suffix", (Object)couchServersConfig.getRequestDatabaseSuffix()).trait("log-level", (Object)levelCode).send().get();
            grizzlyServer.start();
        }
    }
}

