/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common.exceptions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.StringUtils;

public abstract class ExceptionUtils {
    public static Path assertIsFile(Path path) throws IOException {
        return ExceptionUtils.assertIsFile(path, IOException.class);
    }

    public static <X extends Exception> Path assertIsFile(Path path, Class<X> type) throws X {
        ExceptionUtils.assertIsFile(path.toFile(), type);
        return path;
    }

    public static File assertIsFile(File file) throws IOException {
        return ExceptionUtils.assertIsFile(file, IOException.class);
    }

    public static <X extends Exception> File assertIsFile(File file, Class<X> type) throws X {
        ExceptionUtils.assertExists(file, type);
        if (!file.isFile()) {
            String msg = String.format("The path \"%s\" is not a file.", file.getAbsolutePath());
            ExceptionUtils.throwException(type, msg);
        }
        return file;
    }

    public static Path assertIsDirectory(Path path) throws IOException {
        return ExceptionUtils.assertIsDirectory(path, IOException.class);
    }

    public static <X extends Exception> Path assertIsDirectory(Path path, Class<X> type) throws X {
        ExceptionUtils.assertIsDirectory(path.toFile(), type);
        return path;
    }

    public static File assertIsDirectory(File file) throws IOException {
        return ExceptionUtils.assertIsDirectory(file, IOException.class);
    }

    public static <X extends Exception> File assertIsDirectory(File file, Class<X> type) throws X {
        ExceptionUtils.assertExists(file, type);
        if (!file.isDirectory()) {
            String msg = String.format("The path \"%s\" is not a directory.", file.getAbsolutePath());
            ExceptionUtils.throwException(type, msg);
        }
        return file;
    }

    public static Path assertExists(Path path) throws FileNotFoundException {
        return ExceptionUtils.assertExists(path, FileNotFoundException.class);
    }

    public static <X extends Exception> Path assertExists(Path path, Class<X> type) throws X {
        ExceptionUtils.assertExists(path.toFile(), type);
        return path;
    }

    public static File assertExists(File file) throws FileNotFoundException {
        return ExceptionUtils.assertExists(file, FileNotFoundException.class);
    }

    public static <X extends Exception> File assertExists(File file, Class<X> type) throws X {
        if (!file.exists()) {
            String msg = String.format("The path \"%s\" does not exist.", file.getAbsolutePath());
            ExceptionUtils.throwException(type, msg);
        }
        return file;
    }

    public static String assertNotZeroLength(String value, String name) throws NullPointerException {
        return ExceptionUtils.assertNotZeroLength(value, name, NullPointerException.class, IllegalArgumentException.class);
    }

    public static <X1 extends Exception, X2 extends Exception> String assertNotZeroLength(String value, String name, Class<X1> nullType, Class<X2> type) throws X1, X2 {
        ExceptionUtils.assertNotNull(value, name, nullType);
        if (value.isEmpty()) {
            String msg = String.format("The value \"%s\" is an empty string.", name);
            ExceptionUtils.throwException(type, msg);
        }
        return value;
    }

    public static <T> T assertNotNull(T value, String name) {
        return ExceptionUtils.assertNotNull(value, name, NullPointerException.class);
    }

    public static <T, X extends Exception> T assertNotNull(T value, String name, Class<X> type) throws X {
        if (value == null) {
            String msg = String.format("The value \"%s\" cannot be null.", name);
            X ex = ExceptionUtils.createException(type, msg);
            throw ExceptionUtils.trimStackTrace(ex);
        }
        return value;
    }

    public static <T> T[] assertNotEmpty(T[] value, String name) {
        return ExceptionUtils.assertNotEmpty(value, name, NullPointerException.class, IllegalArgumentException.class);
    }

    public static <T, X1 extends Exception, X2 extends Exception> T[] assertNotEmpty(T[] value, String name, Class<X1> nullType, Class<X2> type) throws X1, X2 {
        ExceptionUtils.assertNotNull(value, name, nullType);
        if (value.length == 0) {
            String msg = String.format("The value \"%s\" cannot be empty.", name);
            X2 ex = ExceptionUtils.createException(type, msg);
            throw ExceptionUtils.trimStackTrace(ex);
        }
        return value;
    }

    public static <T> Collection<T> assertNotEmpty(Collection<T> value, String name) {
        return ExceptionUtils.assertNotEmpty(value, name, NullPointerException.class, IllegalArgumentException.class);
    }

    public static <T, X1 extends Exception, X2 extends Exception> Collection<T> assertNotEmpty(Collection<T> value, String name, Class<X1> nullType, Class<X2> type) throws X1, X2 {
        ExceptionUtils.assertNotNull(value, name, nullType);
        if (value.size() == 0) {
            String msg = String.format("The value \"%s\" cannot be empty.", name);
            X2 ex = ExceptionUtils.createException(type, msg);
            throw ExceptionUtils.trimStackTrace(ex);
        }
        return value;
    }

    public static long assertPositive(long value, String name) {
        return ExceptionUtils.assertPositive(value, name, IllegalArgumentException.class);
    }

    public static <X extends Exception> long assertPositive(long value, String name, Class<X> type) throws X {
        if (value <= 0L) {
            String msg = String.format("The value \"%s\" cannot be less than zero.", name);
            X ex = ExceptionUtils.createException(type, msg);
            throw ExceptionUtils.trimStackTrace(ex);
        }
        return value;
    }

    public static long assertNegative(long value, String name) {
        return ExceptionUtils.assertNegative(value, name, IllegalArgumentException.class);
    }

    public static <X extends Exception> long assertNegative(long value, String name, Class<X> type) throws X {
        if (value >= 0L) {
            String msg = String.format("The value \"%s\" cannot be greater than zero.", name);
            throw ExceptionUtils.trimStackTrace(new IllegalArgumentException(msg));
        }
        return value;
    }

    private static <T extends Exception> T trimStackTrace(T ex) {
        ArrayList elements = new ArrayList();
        Collections.addAll(elements, ex.getStackTrace());
        elements.remove(0);
        ex.setStackTrace(ReflectUtils.toArray(StackTraceElement.class, elements));
        return ex;
    }

    public static String toString(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable cause = e.getCause();
        while (cause != null && cause != e) {
            e = cause;
            cause = e.getCause();
        }
        return e;
    }

    public static String getMessage(Throwable ex) {
        String msg = ex.getMessage();
        return StringUtils.isBlank(msg) ? ex.getClass().getName() : msg;
    }

    public static String getRootMessage(Throwable ex) {
        String msg = (ex = ExceptionUtils.getRootCause(ex)).getMessage();
        return StringUtils.isBlank(msg) ? ex.getClass().getName() : msg;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        return writer.toString();
    }

    public static List<? extends Throwable> getRootCauses(Throwable e) {
        Throwable last = e.getCause();
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        list.add(e);
        while (last != e && last != null) {
            list.add(last);
            e = last;
            last = e.getCause();
        }
        return list;
    }

    public static <X extends Exception> X createException(Class<X> type, String msg) {
        try {
            return (X)((Exception)type.getConstructor(String.class).newInstance(msg));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errMsg = String.format("Could not create constructor for %s with a single String parameter.", type.getName());
            throw new RuntimeException(errMsg, e);
        }
    }

    public static <X extends Exception> void throwException(Class<X> type, String msg) throws X {
        try {
            throw (Exception)type.getConstructor(String.class).newInstance(msg);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errMsg = String.format("Could not create constructor for %s with a single String parameter.", type.getName());
            throw new RuntimeException(errMsg, e);
        }
    }
}

