/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.route.DestinationDef;
import org.tiogasolutions.notify.pub.route.DestinationStatus;
import org.tiogasolutions.notify.pub.route.Route;
import org.tiogasolutions.notify.pub.route.RouteDef;
import org.tiogasolutions.notify.pub.route.RouteStatus;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RouteCatalog {
    private static final Logger logger = LoggerFactory.getLogger(RouteCatalog.class);
    private final List<RouteDef> routes;
    private final List<DestinationDef> destinations;

    @JsonCreator
    public RouteCatalog(@JsonProperty(value="destinations") List<DestinationDef> destinations, @JsonProperty(value="routes") List<RouteDef> routes) {
        this.destinations = destinations != null ? Collections.unmodifiableList(destinations) : Collections.emptyList();
        this.routes = routes != null ? Collections.unmodifiableList(routes) : Collections.emptyList();
    }

    public static RouteCatalog newEmptyCatalog() {
        return new RouteCatalog(Collections.emptyList(), Collections.emptyList());
    }

    public Map<String, Destination> mapDestinations() {
        HashMap<String, Destination> map = new HashMap<String, Destination>();
        for (DestinationDef destinationDef : this.getDestinations()) {
            Destination destination = destinationDef.toDestination();
            map.put(destination.getName().toLowerCase(), destination);
        }
        return map;
    }

    public List<Route> loadActiveRoutes() {
        Map<String, Destination> destinationMap = this.mapDestinations();
        ArrayList<Route> routeList = new ArrayList<Route>();
        for (RouteDef routeDef : this.getRoutes()) {
            if (routeDef.getRouteStatus() != RouteStatus.ENABLED) continue;
            ArrayList<Destination> routeDestinations = new ArrayList<Destination>();
            for (String destinationName : routeDef.getDestinations()) {
                Destination destination = destinationMap.get(destinationName.toLowerCase());
                if (destination == null) {
                    String msg = String.format("The destination \"%s\", specified by the route \"%s\" was not found.", destinationName, routeDef.getName());
                    logger.error(msg);
                    continue;
                }
                if (destination.getDestinationStatus() != DestinationStatus.ENABLED) continue;
                routeDestinations.add(destination);
            }
            Route route = new Route(routeDef.getName(), routeDef.getRouteStatus(), routeDef.getEval(), routeDestinations);
            routeList.add(route);
        }
        return routeList;
    }

    public List<DestinationDef> getDestinations() {
        return this.destinations;
    }

    public List<RouteDef> getRoutes() {
        return this.routes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteCatalog that = (RouteCatalog)o;
        if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) {
            return false;
        }
        return !(this.routes != null ? !this.routes.equals(that.routes) : that.routes != null);
    }

    public int hashCode() {
        int result = this.routes != null ? this.routes.hashCode() : 0;
        result = 31 * result + (this.destinations != null ? this.destinations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RouteCatalog{routes=" + this.routes + ", destinations=" + this.destinations + '}';
    }
}

