/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.dev.common.exceptions.ApiBadRequestException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.notify.pub.route.RouteStatus;

public class RouteDef {
    private final String name;
    private final RouteStatus routeStatus;
    private final String eval;
    private final List<String> destinations;

    public RouteDef(String name, RouteStatus routeStatus, String eval, String ... destinations) {
        this(name, routeStatus, eval, Arrays.asList(destinations));
    }

    @JsonCreator
    public RouteDef(@JsonProperty(value="name") String name, @JsonProperty(value="routeStatus") RouteStatus routeStatus, @JsonProperty(value="eval") String eval, @JsonProperty(value="destinations") List<String> destinations) {
        this.name = ExceptionUtils.assertNotZeroLength((String)name, (String)"name", ApiBadRequestException.class, ApiBadRequestException.class);
        this.eval = ExceptionUtils.assertNotZeroLength((String)eval, (String)"eval", ApiBadRequestException.class, ApiBadRequestException.class);
        this.routeStatus = (RouteStatus)((Object)ExceptionUtils.assertNotNull((Object)((Object)routeStatus), (String)"routeStatus", ApiBadRequestException.class));
        this.destinations = destinations != null ? Collections.unmodifiableList(destinations) : Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public RouteStatus getRouteStatus() {
        return this.routeStatus;
    }

    public String getEval() {
        return this.eval;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteDef that = (RouteDef)o;
        if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) {
            return false;
        }
        if (this.eval != null ? !this.eval.equals(that.eval) : that.eval != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.routeStatus == that.routeStatus;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.routeStatus != null ? this.routeStatus.hashCode() : 0);
        result = 31 * result + (this.eval != null ? this.eval.hashCode() : 0);
        result = 31 * result + (this.destinations != null ? this.destinations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RouteDef{name='" + this.name + '\'' + ", routeStatus=" + (Object)((Object)this.routeStatus) + ", eval='" + this.eval + '\'' + ", destinations=" + this.destinations + '}';
    }
}

