/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.smtp;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.domain.comm.AuthenticationMethod;
import org.tiogasolutions.notify.processor.smtp.EmailMessageException;

public class EmailMessage {
    private static Log log = LogFactory.getLog(EmailMessage.class);
    protected final List<InternetAddress> toAddresses = new ArrayList<InternetAddress>();
    protected final List<InternetAddress> replyToAddress = new ArrayList<InternetAddress>();
    protected final List<File> attachments = new ArrayList<File>();
    protected String host;
    protected String port;
    protected InternetAddress fromAddress;
    protected String subject;
    protected String text;
    protected String html;
    private AuthenticationMethod authenticationMethod = AuthenticationMethod.NONE;
    private String userName;
    private String password;

    public EmailMessage(String host, String port, String address) throws EmailMessageException {
        this(host, port, Arrays.asList(address));
    }

    public EmailMessage(String host, String port, List<String> addresses) throws EmailMessageException {
        this.host = host;
        this.port = port;
        for (String address : addresses) {
            try {
                InternetAddress[] list = InternetAddress.parse((String)address);
                this.toAddresses.addAll(Arrays.asList(list));
            }
            catch (Exception ex) {
                throw new EmailMessageException("Exception parsing the email address: " + address);
            }
        }
    }

    public String getUsername() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setAuthentication(AuthenticationMethod authenticationMethod, String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.authenticationMethod = authenticationMethod;
    }

    public void send() throws EmailMessageException {
        try {
            Authenticator authenticator;
            if (this.toAddresses.size() == 0) {
                throw new EmailMessageException("At least one recipient must be specified in order to send the message.");
            }
            Properties props = new Properties();
            if (this.host != null) {
                props.put("mail.smtp.host", this.host);
            }
            if (this.port != null) {
                props.put("mail.smtp.port", this.port);
            }
            if (AuthenticationMethod.NONE == this.authenticationMethod) {
                authenticator = null;
            } else if (AuthenticationMethod.SSL == this.authenticationMethod) {
                authenticator = this.newAuthenticator();
                props.put("mail.smtp.auth", "true");
                props.put("mail.smtp.port", "465");
                props.put("mail.smtp.socketFactory.port", "465");
                props.put("mail.smtp.socketFactory.class", SSLSocketFactory.class.getName());
            } else if (AuthenticationMethod.TLS == this.authenticationMethod) {
                authenticator = this.newAuthenticator();
                props.put("mail.smtp.auth", "true");
                props.put("mail.smtp.port", "587");
                props.put("mail.smtp.starttls.enable", "true");
            } else {
                String msg = String.format("The authentication method %s is not supported.", this.authenticationMethod);
                throw new IllegalArgumentException(msg);
            }
            Session session = Session.getInstance((Properties)props, authenticator);
            this.send(session);
        }
        catch (Exception ex) {
            throw new EmailMessageException("Exception sending email\n" + this.toString(), ex);
        }
    }

    public Authenticator newAuthenticator() {
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailMessage.this.userName, EmailMessage.this.password);
            }
        };
    }

    protected void send(Session session) throws EmailMessageException {
        try {
            MimeBodyPart bodyPart;
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)this.fromAddress);
            msg.setRecipients(Message.RecipientType.TO, (Address[])ReflectUtils.toArray(InternetAddress.class, this.toAddresses));
            msg.setSubject(this.subject);
            msg.setSentDate(new Date());
            if (!this.replyToAddress.isEmpty()) {
                msg.setReplyTo((Address[])ReflectUtils.toArray(InternetAddress.class, this.replyToAddress));
            }
            MimeMultipart multipart = new MimeMultipart();
            msg.setContent((Multipart)multipart);
            if (this.html != null) {
                bodyPart = new MimeBodyPart();
                bodyPart.setText(this.html, "UTF-8", "html");
                multipart.addBodyPart((BodyPart)bodyPart);
            }
            if (this.text != null) {
                bodyPart = new MimeBodyPart();
                bodyPart.setText(this.text, "UTF-8", "plain");
                multipart.addBodyPart((BodyPart)bodyPart);
            }
            if (this.html == null && this.text == null) {
                bodyPart = new MimeBodyPart();
                bodyPart.setText("", "UTF-8", "plain");
                multipart.addBodyPart((BodyPart)bodyPart);
            }
            while (this.attachments.remove(null)) {
            }
            for (File file : this.attachments) {
                if (!file.exists()) {
                    throw new EmailMessageException("The file \"" + file.getAbsolutePath() + "\" does not exist.");
                }
                MimeBodyPart attachmentPart = new MimeBodyPart();
                attachmentPart.attachFile(file);
                multipart.addBodyPart((BodyPart)attachmentPart);
            }
            Transport.send((Message)msg);
        }
        catch (EmailMessageException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EmailMessageException("Exception sending email\n" + this.toString(), ex);
        }
    }

    public void send(String subject, String text, String html, File ... attachments) throws EmailMessageException {
        this.send(subject, text, html, Arrays.asList(attachments));
    }

    public void send(String subject, String text, String html, List<File> attachments) throws EmailMessageException {
        this.setSubject(subject);
        this.setText(text);
        this.setHtml(html);
        this.addAttachments(attachments);
        this.send();
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public List<String> getTo() {
        ArrayList<String> retVal = new ArrayList<String>();
        for (InternetAddress addr : this.toAddresses) {
            retVal.add(addr.getAddress());
        }
        return retVal;
    }

    public String getFrom() {
        return this.fromAddress == null ? null : this.fromAddress.getAddress();
    }

    public void setFrom(String from) throws EmailMessageException {
        if (from == null) {
            from = "DO_NOT_REPLY";
        }
        try {
            InternetAddress[] addresses = InternetAddress.parse((String)from);
            if (addresses.length != 1) {
                throw new EmailMessageException("One and only one \"from\" address may be specified, " + addresses.length + " were found: " + from);
            }
            this.fromAddress = addresses[0];
        }
        catch (EmailMessageException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EmailMessageException("Exception parsing the email addresses");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public List<String> getReplyTo() {
        ArrayList<String> retVal = new ArrayList<String>();
        for (InternetAddress addr : this.replyToAddress) {
            retVal.add(addr.getAddress());
        }
        return retVal;
    }

    public void addReplyTo(String ... addresses) throws EmailMessageException {
        this.addReplyTo(Arrays.asList(addresses));
    }

    public void addReplyTo(List<String> replyAddress) throws EmailMessageException {
        for (String address : replyAddress) {
            try {
                InternetAddress[] list = InternetAddress.parse((String)address);
                this.replyToAddress.addAll(Arrays.asList(list));
            }
            catch (Exception ex) {
                throw new EmailMessageException("Exception parsing the email address: " + address);
            }
        }
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String value) {
        this.html = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<File> getAttachments() {
        return new ArrayList<File>(this.attachments);
    }

    public void addAttachments(List<File> values) {
        this.attachments.addAll(values);
    }

    public void addAttachments(File ... values) {
        this.attachments.addAll(Arrays.asList(values));
    }

    public String toString() {
        String retVal = "to: ";
        List<String> tos = this.getTo();
        for (String to : tos) {
            retVal = retVal + to;
            if (!tos.iterator().hasNext()) continue;
            retVal = retVal + ", ";
        }
        retVal = retVal + " subject: " + this.getSubject();
        return retVal;
    }
}

