/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import org.tiogasolutions.couchace.core.api.query.CouchJsonKey;
import org.tiogasolutions.couchace.core.api.response.CouchDocument;

public final class EntityDocument<T>
implements CouchDocument<T> {
    private final String documentId;
    private final String documentRevision;
    private final CouchJsonKey key;
    private final String entityType;
    private final Class<?> entityClass;
    private final T entity;

    public EntityDocument(String documentId, String documentRevision, CouchJsonKey key, String entityType, T entity) {
        this.documentId = documentId;
        this.documentRevision = documentRevision;
        this.key = key;
        this.entityType = entityType;
        this.entity = entity;
        this.entityClass = entity != null ? entity.getClass() : Object.class;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public String getDocumentRevision() {
        return this.documentRevision;
    }

    @Override
    public CouchJsonKey getKey() {
        return this.key;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public T getEntity() {
        return this.entity;
    }

    @Override
    public T getContent() {
        return this.entity;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityDocument that = (EntityDocument)o;
        if (this.documentId != null ? !this.documentId.equals(that.documentId) : that.documentId != null) {
            return false;
        }
        if (this.documentRevision != null ? !this.documentRevision.equals(that.documentRevision) : that.documentRevision != null) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(that.entity) : that.entity != null) {
            return false;
        }
        if (!this.entityClass.equals(that.entityClass)) {
            return false;
        }
        return !(this.entityType != null ? !this.entityType.equals(that.entityType) : that.entityType != null);
    }

    public int hashCode() {
        int result = this.documentId != null ? this.documentId.hashCode() : 0;
        result = 31 * result + (this.documentRevision != null ? this.documentRevision.hashCode() : 0);
        result = 31 * result + (this.entityType != null ? this.entityType.hashCode() : 0);
        result = 31 * result + this.entityClass.hashCode();
        result = 31 * result + (this.entity != null ? this.entity.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EntityDocument{documentId='" + this.documentId + '\'' + ", documentRevision='" + this.documentRevision + '\'' + ", key=" + this.key + ", entityType='" + this.entityType + '\'' + ", entityClass=" + this.entityClass + ", entity=" + this.entity + '}';
    }
}

