/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfo;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.notify.pub.attachment.AttachmentInfo;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.common.Link;
import org.tiogasolutions.notify.pub.request.NotificationRequest;
import org.tiogasolutions.notify.pub.request.NotificationRequestStatus;

@CouchEntity(value="NotificationRequest")
public class NotificationRequestEntity {
    public static final String ENTITY_TYPE = "NotificationRequest";
    private final String requestId;
    private final boolean internal;
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final List<Link> links;
    private final ExceptionInfo exceptionInfo;
    public NotificationRequestStatus requestStatus;
    private String revision;
    private CouchAttachmentInfoMap attachmentInfoMap;

    @JsonCreator
    public NotificationRequestEntity(@JsonProperty(value="internal", defaultValue="false") boolean internal, @JsonProperty(value="requestId") String requestId, @JsonProperty(value="revision") String revision, @JsonProperty(value="requestStatus") NotificationRequestStatus requestStatus, @JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="traitMap") Map<String, String> traitMap, @JsonProperty(value="links") List<Link> links, @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo) {
        this.internal = internal;
        this.requestId = requestId;
        this.revision = revision;
        this.requestStatus = requestStatus;
        this.topic = topic;
        this.summary = summary;
        this.trackingId = trackingId;
        this.createdAt = createdAt;
        this.links = links != null ? Collections.unmodifiableList(links) : Collections.emptyList();
        this.exceptionInfo = exceptionInfo;
        this.traitMap = traitMap != null ? Collections.unmodifiableMap(new LinkedHashMap<String, String>(traitMap)) : Collections.emptyMap();
    }

    public static NotificationRequestEntity newEntity(NotificationRequest request) {
        ZonedDateTime createdAt;
        NotificationRequestStatus requestStatus;
        String requestId = request.getRequestId();
        if (requestId == null) {
            requestId = TimeUuid.randomUUID().toString();
        }
        if ((requestStatus = request.getRequestStatus()) == null || requestStatus.isNotReady()) {
            requestStatus = NotificationRequestStatus.SENDING;
        }
        if ((createdAt = request.getCreatedAt()) == null) {
            ZonedDateTime.now();
        }
        return new NotificationRequestEntity(request.isInternal(), requestId, null, requestStatus, request.getTopic(), request.getSummary(), request.getTrackingId(), createdAt, request.getTraitMap(), request.getLinks(), request.getExceptionInfo());
    }

    public void ready() {
        if (this.requestStatus != NotificationRequestStatus.SENDING) {
            throw new BadRequestException("Cannot set request to ready, status is " + this.requestStatus);
        }
        this.requestStatus = NotificationRequestStatus.READY;
    }

    public void processing() {
        if (this.requestStatus != NotificationRequestStatus.READY) {
            throw new BadRequestException("Cannot set request to processing, status is " + this.requestStatus);
        }
        this.requestStatus = NotificationRequestStatus.PROCESSING;
    }

    public void completed() {
        if (this.requestStatus != NotificationRequestStatus.PROCESSING) {
            throw new BadRequestException("Cannot set request to completed, status is " + this.requestStatus);
        }
        this.requestStatus = NotificationRequestStatus.COMPLETED;
    }

    public void failed() {
        if (this.requestStatus != NotificationRequestStatus.PROCESSING) {
            throw new BadRequestException("Cannot set request to failed, status is " + this.requestStatus);
        }
        this.requestStatus = NotificationRequestStatus.FAILED;
    }

    public void ready(String currentRevision) {
        if (this.requestStatus != NotificationRequestStatus.SENDING) {
            throw new BadRequestException("Cannot change status to READY, current status is " + this.requestStatus);
        }
        this.requestStatus = NotificationRequestStatus.READY;
        this.revision = currentRevision;
    }

    public NotificationRequest toRequest() {
        return new NotificationRequest(this.isInternal(), this.getRequestId(), this.getRevision(), this.getRequestStatus(), this.getTopic(), this.getSummary(), this.getTrackingId(), this.getCreatedAt(), this.getTraitMap(), this.getLinks(), this.getExceptionInfo(), this.listAttachmentInfo());
    }

    @CouchId
    public String getRequestId() {
        return this.requestId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public NotificationRequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<AttachmentInfo> listAttachmentInfo() {
        ArrayList<AttachmentInfo> attachmentInfoList = new ArrayList<AttachmentInfo>();
        if (this.attachmentInfoMap != null) {
            for (Map.Entry entry : this.attachmentInfoMap.entrySet()) {
                AttachmentInfo attachInfo = new AttachmentInfo((String)entry.getKey(), ((CouchAttachmentInfo)entry.getValue()).getContentType());
                attachmentInfoList.add(attachInfo);
            }
        }
        return attachmentInfoList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRequestEntity that = (NotificationRequestEntity)o;
        if (this.internal != that.internal) {
            return false;
        }
        if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.trackingId != null ? !this.trackingId.equals(that.trackingId) : that.trackingId != null) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.traitMap != null ? !this.traitMap.equals(that.traitMap) : that.traitMap != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.exceptionInfo != null ? !this.exceptionInfo.equals((Object)that.exceptionInfo) : that.exceptionInfo != null) {
            return false;
        }
        if (this.requestStatus != that.requestStatus) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        return this.attachmentInfoMap != null ? this.attachmentInfoMap.equals(that.attachmentInfoMap) : that.attachmentInfoMap == null;
    }

    public int hashCode() {
        int result = this.requestId != null ? this.requestId.hashCode() : 0;
        result = 31 * result + (this.internal ? 1 : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.trackingId != null ? this.trackingId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.traitMap != null ? this.traitMap.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.exceptionInfo != null ? this.exceptionInfo.hashCode() : 0);
        result = 31 * result + (this.requestStatus != null ? this.requestStatus.hashCode() : 0);
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.attachmentInfoMap != null ? this.attachmentInfoMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NotificationRequestEntity{requestId='" + this.requestId + '\'' + ", internal=" + this.internal + ", topic='" + this.topic + '\'' + ", summary='" + this.summary + '\'' + ", trackingId='" + this.trackingId + '\'' + ", createdAt=" + this.createdAt + ", traitMap=" + this.traitMap + ", links=" + this.links + ", exceptionInfo=" + this.exceptionInfo + ", requestStatus=" + this.requestStatus + ", revision='" + this.revision + '\'' + ", attachmentInfoMap=" + this.attachmentInfoMap + '}';
    }
}

