/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.task;

import java.util.Collection;
import java.util.List;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiBadRequestException;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.notify.kernel.common.AbstractStore;
import org.tiogasolutions.notify.kernel.task.CreateTask;
import org.tiogasolutions.notify.kernel.task.TaskCouchView;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.pub.task.TaskQuery;
import org.tiogasolutions.notify.pub.task.TaskStatus;

public class TaskStore
extends AbstractStore {
    public TaskStore(CouchDatabase couchDatabase) {
        super(couchDatabase);
    }

    public TaskEntity createTask(CreateTask create) {
        ExceptionUtils.assertNotNull((Object)create, (String)"create", ApiBadRequestException.class);
        TaskEntity entity = TaskEntity.newEntity(create);
        this.couchDatabase.put().entity((Object)entity).onError(r -> this.throwError(r, String.format("Error creating %s with id %s", TaskEntity.class.getName(), entity.getTaskId()))).execute();
        return this.findTaskById(entity.getTaskId());
    }

    public void save(TaskEntity entity) {
        ExceptionUtils.assertNotNull((Object)entity, (String)"entity", ApiBadRequestException.class);
        this.couchDatabase.put().entity((Object)entity).onError(r -> this.throwError(r, String.format("Error saving %s with id %s", TaskEntity.class, entity.getTaskId()))).execute();
    }

    public TaskEntity saveAndReload(TaskEntity entity) {
        this.save(entity);
        return this.findTaskById(entity.getTaskId());
    }

    public void deleteTask(String taskId) {
        TaskEntity task;
        ExceptionUtils.assertNotNull((Object)taskId, (String)"taskId", ApiBadRequestException.class);
        try {
            task = this.findTaskById(taskId);
        }
        catch (ApiNotFoundException e) {
            return;
        }
        this.couchDatabase.delete().document(task.getTaskId(), task.getRevision()).onError(r -> this.throwError(r, String.format("Error deleting %s with id %s", TaskEntity.class, task.getTaskId()))).execute();
    }

    public ListQueryResult<TaskEntity> query(TaskQuery query) {
        CouchViewQuery viewQuery;
        String errorSuffix;
        int limit;
        int n = limit = query.getLimit() <= 500 ? query.getLimit() : 500;
        if (query.getTaskStatus() != null) {
            errorSuffix = "by task status";
            TaskStatus taskStatus = query.getTaskStatus();
            viewQuery = CouchViewQuery.builder((String)"Task", (String)TaskCouchView.ByTaskStatusAndCreatedAt.name()).start(new Object[]{taskStatus, "\\ufff0"}).end(new Object[]{taskStatus, null}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        } else if (StringUtils.isNotBlank((Object)query.getDestinationName())) {
            errorSuffix = "by destination name";
            String destinationName = query.getDestinationName();
            viewQuery = CouchViewQuery.builder((String)"Task", (String)TaskCouchView.ByDestinationNameAndCreatedAt.name()).start(new Object[]{destinationName, "\\ufff0"}).end(new Object[]{destinationName, null}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        } else if (StringUtils.isNotBlank((Object)query.getDestinationProvider())) {
            errorSuffix = "by destination provider";
            String destinationProvider = query.getDestinationProvider();
            viewQuery = CouchViewQuery.builder((String)"Task", (String)TaskCouchView.ByDestinationProviderAndCreatedAt.name()).start(new Object[]{destinationProvider, "\\ufff0"}).end(new Object[]{destinationProvider, null}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        } else if (StringUtils.isNotBlank((Object)query.getNotificationId())) {
            errorSuffix = "by destination notification id";
            viewQuery = CouchViewQuery.builder((String)"Task", (String)TaskCouchView.ByNotification.name()).key(new Object[]{query.getNotificationId()}).limit(limit).build();
        } else {
            errorSuffix = "by created at";
            viewQuery = CouchViewQuery.builder((String)"Task", (String)TaskCouchView.ByCreatedAt.name()).start(new Object[]{"\\ufff0"}).end(new Object[]{null}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        }
        GetEntityResponse getResponse = this.couchDatabase.get().entity(TaskEntity.class, viewQuery).onError(r -> {
            if (!r.isNotFound()) {
                this.throwError(r, "Error finding Notification " + errorSuffix);
            }
        }).execute();
        List tasks = getResponse.getEntityList();
        return ListQueryResult.newResult(TaskEntity.class, (int)limit, (int)0, (int)tasks.size(), (boolean)false, (Collection)tasks);
    }

    public TaskEntity findTaskById(String entityId) {
        ExceptionUtils.assertNotNull((Object)entityId, (String)"entityId", ApiBadRequestException.class);
        GetEntityResponse getResponse = this.couchDatabase.get().entity(TaskEntity.class, entityId).onError(r -> this.throwError(r, String.format("Error finding %s with id %s", TaskEntity.class, entityId))).onResponse(r -> this.throwIfNotFound((GetEntityResponse)r, String.format("%s not found with id %s", TaskEntity.class, entityId))).execute();
        return (TaskEntity)getResponse.getFirstEntity();
    }
}

