/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.uuid;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.omg.CORBA.portable.IDLEntity;
import org.tiogasolutions.notify.notifier.uuid.TimeUuidFactory;
import org.tiogasolutions.notify.notifier.uuid.TimeUuidHexUtil;

public class TimeUuid
implements Comparable<TimeUuid>,
Externalizable,
Cloneable,
IDLEntity {
    public long time;
    public long clockSeqAndNode;

    public TimeUuid() {
        this(TimeUuidFactory.newTime(), TimeUuidFactory.getClockSeqAndNode());
    }

    public TimeUuid(long time, long clockSeqAndNode) {
        this.time = time;
        this.clockSeqAndNode = clockSeqAndNode;
    }

    public TimeUuid(TimeUuid u) {
        this(u.time, u.clockSeqAndNode);
    }

    public TimeUuid(CharSequence s) {
        this(TimeUuidHexUtil.parseLong(s.subSequence(0, 18)), TimeUuidHexUtil.parseLong(s.subSequence(19, 36)));
    }

    public static TimeUuid randomUUID() {
        return new TimeUuid();
    }

    public static TimeUuid nilUUID() {
        return new TimeUuid(0L, 0L);
    }

    @Override
    public int compareTo(TimeUuid t) {
        if (this == t) {
            return 0;
        }
        if (this.time > t.time) {
            return 1;
        }
        if (this.time < t.time) {
            return -1;
        }
        if (this.clockSeqAndNode > t.clockSeqAndNode) {
            return 1;
        }
        if (this.clockSeqAndNode < t.clockSeqAndNode) {
            return -1;
        }
        return 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeLong(this.clockSeqAndNode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.time = in.readLong();
        this.clockSeqAndNode = in.readLong();
    }

    public final String toString() {
        return this.toAppendable(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer in) {
        StringBuffer out = in;
        if (out == null) {
            out = new StringBuffer(36);
        } else {
            out.ensureCapacity(out.length() + 36);
        }
        return (StringBuffer)this.toAppendable(out);
    }

    public Appendable toAppendable(Appendable a) {
        Appendable out = a;
        if (out == null) {
            out = new StringBuilder(36);
        }
        try {
            TimeUuidHexUtil.append(out, (int)(this.time >> 32)).append('-');
            TimeUuidHexUtil.append(out, (short)(this.time >> 16)).append('-');
            TimeUuidHexUtil.append(out, (short)this.time).append('-');
            TimeUuidHexUtil.append(out, (short)(this.clockSeqAndNode >> 48)).append('-');
            TimeUuidHexUtil.append(out, this.clockSeqAndNode, 12);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    public int hashCode() {
        return (int)(this.time >> 32 ^ this.time ^ this.clockSeqAndNode >> 32 ^ this.clockSeqAndNode);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public final long getTime() {
        return this.time;
    }

    public final long getClockSeqAndNode() {
        return this.clockSeqAndNode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeUuid)) {
            return false;
        }
        return this.compareTo((TimeUuid)obj) == 0;
    }
}

