/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.slack;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.StringUtils;

public class SlackMessage {
    private static Logger log = LoggerFactory.getLogger(SlackMessage.class);
    private String username;
    private String channel;
    private String text;
    private String iconUrl;
    private String iconEmoji;

    public SlackMessage() {
    }

    @JsonCreator
    public SlackMessage(@JsonProperty(value="username") String username, @JsonProperty(value="channel") String channel, @JsonProperty(value="text") String text, @JsonProperty(value="icon_url") String iconUrl, @JsonProperty(value="icon_emoji") String iconEmoji) {
        this.username = username;
        this.channel = channel;
        this.text = text;
        this.iconUrl = iconUrl;
        if (StringUtils.isBlank((Object)iconUrl)) {
            this.iconEmoji = iconEmoji;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public SlackMessage setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getChannel() {
        return this.channel;
    }

    public SlackMessage setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public SlackMessage setText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty(value="icon_url")
    public String getIconUrl() {
        return this.iconUrl;
    }

    public SlackMessage setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        this.iconEmoji = null;
        return this;
    }

    @JsonProperty(value="icon_emoji")
    public String getIconEmoji() {
        return this.iconEmoji;
    }

    public SlackMessage setIconEmoji(String iconEmoji) {
        this.iconEmoji = iconEmoji;
        this.iconUrl = null;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackMessage message = (SlackMessage)o;
        if (this.channel != null ? !this.channel.equals(message.channel) : message.channel != null) {
            return false;
        }
        if (this.iconEmoji != null ? !this.iconEmoji.equals(message.iconEmoji) : message.iconEmoji != null) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(message.iconUrl) : message.iconUrl != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(message.text) : message.text != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(message.username) : message.username != null);
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.iconUrl != null ? this.iconUrl.hashCode() : 0);
        result = 31 * result + (this.iconEmoji != null ? this.iconEmoji.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SlackMessage{username='" + this.username + '\'' + ", channel='" + this.channel + '\'' + ", text='" + this.text + '\'' + ", iconUrl='" + this.iconUrl + '\'' + ", iconEmoji='" + this.iconEmoji + '\'' + '}';
    }
}

