/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.couchace.core.api.CouchSetup;
import org.tiogasolutions.couchace.core.api.request.CouchFeature;
import org.tiogasolutions.couchace.core.api.request.CouchFeatureSet;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.couchace.core.internal.util.StringUtil;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;
import org.tiogasolutions.couchace.jackson.JacksonCouchJsonStrategy;
import org.tiogasolutions.couchace.jersey.JerseyCouchHttpClient;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.NotifyJacksonModule;
import org.tiogasolutions.notify.kernel.config.CouchEnvironment;
import org.tiogasolutions.notify.kernel.config.CouchServersConfig;

@Component
public class CouchServers {
    private final CouchEnvironment couchEnvironment;
    private final CouchServersConfig serversConfig;
    private final CouchServer masterServer;
    private final CouchDatabase masterDatabase;
    private final CouchServer notificationServer;
    private final String notificationDatabasePrefix;
    private final String notificationDatabaseSuffix;
    private final CouchServer requestServer;
    private final String requestDatabasePrefix;
    private final String requestDatabaseSuffix;

    @Autowired
    public CouchServers(CouchEnvironment couchEnvironment, CouchServersConfig serversConfig) {
        this.couchEnvironment = couchEnvironment;
        this.serversConfig = serversConfig;
        this.notificationDatabasePrefix = serversConfig.getNotificationDatabasePrefix();
        this.notificationDatabaseSuffix = serversConfig.getNotificationDatabaseSuffix();
        this.requestDatabasePrefix = serversConfig.getRequestDatabasePrefix();
        this.requestDatabaseSuffix = serversConfig.getRequestDatabaseSuffix();
        JacksonCouchJsonStrategy jsonStrategy = new JacksonCouchJsonStrategy(new Module[]{new JSR310Module(), new NotifyJacksonModule()});
        CouchSetup masterConfig = new CouchSetup(serversConfig.getMasterUrl()).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)jsonStrategy).setUserName(serversConfig.getMasterUsername()).setPassword(serversConfig.getMasterPassword());
        this.masterServer = new CouchServer(masterConfig);
        this.masterDatabase = this.initMasterDatabase(serversConfig, this.masterServer);
        CouchSetup notificationConfig = new CouchSetup(serversConfig.getNotificationUrl()).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)jsonStrategy).setUserName(serversConfig.getNotificationUsername()).setPassword(serversConfig.getNotificationPassword());
        this.notificationServer = new CouchServer(notificationConfig);
        CouchSetup requestConfig = new CouchSetup(serversConfig.getRequestUrl()).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)jsonStrategy).setUserName(serversConfig.getRequestUsername()).setPassword(serversConfig.getRequestPassword());
        this.requestServer = new CouchServer(requestConfig);
    }

    private CouchDatabase initMasterDatabase(CouchServersConfig serversConfig, CouchServer masterServer) {
        CouchDatabase localMasterDatabase;
        if (this.couchEnvironment.isTesting()) {
            CouchFeatureSet featureSet = CouchFeatureSet.builder().add(CouchFeature.ALLOW_DB_DELETE, (Object)true).build();
            CouchDatabase masterDatabaseForDelete = masterServer.database(serversConfig.getMasterDatabaseName(), featureSet);
            masterDatabaseForDelete.deleteDatabase();
        }
        if (!(localMasterDatabase = masterServer.database(serversConfig.getMasterDatabaseName())).exists()) {
            String[] designNames;
            WriteResponse createResponse = localMasterDatabase.createDatabase();
            if (createResponse.isError()) {
                String msg = String.format("Error creating master database (%s) - %s", localMasterDatabase.getDatabaseName(), createResponse.getErrorReason());
                throw ApiException.internalServerError((String)msg, (String[])new String[0]);
            }
            for (String designName : designNames = new String[]{"DomainProfile", "Entity"}) {
                String designPath = String.format("/couch/%s-design.json", designName);
                InputStream designStream = this.getClass().getResourceAsStream(designPath);
                if (designStream == null) {
                    String msg = String.format("Unable to find couch design file at: %s", designPath);
                    throw ApiException.internalServerError((String)msg, (String[])new String[0]);
                }
                try {
                    String designContent = IoUtils.toString((InputStream)designStream);
                    WriteResponse response = localMasterDatabase.put().design(designName, designContent).execute();
                    if (!response.isError()) continue;
                    String msg = String.format("Error creating views %s - %s", response.getHttpStatus(), response.getErrorReason());
                    throw ApiException.internalServerError((String)msg, (String[])new String[0]);
                }
                catch (IOException ex) {
                    String msg = "Error reading design file: " + designPath;
                    throw ApiException.internalServerError((Throwable)ex, (String[])new String[]{msg});
                }
            }
        }
        return localMasterDatabase;
    }

    public void deleteDomainDatabases(String domainName) {
        String requestDbName;
        CouchDatabase requestDatabase;
        CouchFeatureSet featureSet = CouchFeatureSet.builder().add(CouchFeature.ALLOW_DB_DELETE, (Object)true).build();
        String notificationDbName = this.buildNotificationDbName(domainName);
        CouchDatabase notificationDatabase = this.notificationServer.database(notificationDbName, featureSet);
        if (notificationDatabase.exists()) {
            notificationDatabase.deleteDatabase();
        }
        if ((requestDatabase = this.requestServer.database(requestDbName = this.buildRequestDbName(domainName), featureSet)).exists()) {
            requestDatabase.deleteDatabase();
        }
    }

    public String buildRequestDbName(String domainName) {
        String prefix = this.requestDatabasePrefix;
        String suffix = this.requestDatabaseSuffix;
        return this.buildDbName(domainName, "notify-request-", prefix, suffix);
    }

    public String buildNotificationDbName(String domainName) {
        String prefix = this.notificationDatabasePrefix;
        String suffix = this.notificationDatabaseSuffix;
        return this.buildDbName(domainName, "notify-notification-", prefix, suffix);
    }

    protected String buildDbName(String domainName, String defaultPrefix, String prefix, String suffix) {
        if (StringUtil.isNotBlank((String)prefix) && StringUtil.isNotBlank((String)suffix)) {
            return prefix + domainName + suffix;
        }
        if (StringUtil.isNotBlank((String)prefix)) {
            return prefix + domainName;
        }
        if (StringUtil.isNotBlank((String)suffix)) {
            return domainName + suffix;
        }
        return defaultPrefix + domainName;
    }

    public CouchServersConfig getServersConfig() {
        return this.serversConfig;
    }

    public CouchServer getMasterServer() {
        return this.masterServer;
    }

    public CouchDatabase getMasterDatabase() {
        return this.masterDatabase;
    }

    public CouchServer getNotificationServer() {
        return this.notificationServer;
    }

    public CouchServer getRequestServer() {
        return this.requestServer;
    }

    public String getNotificationDatabasePrefix() {
        return this.notificationDatabasePrefix;
    }

    public String getNotificationDatabaseSuffix() {
        return this.notificationDatabaseSuffix;
    }

    public String getRequestDatabasePrefix() {
        return this.requestDatabasePrefix;
    }

    public String getRequestDatabaseSuffix() {
        return this.requestDatabaseSuffix;
    }

    public CouchEnvironment getEnvironment() {
        return this.couchEnvironment;
    }
}

