/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.receiver;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.receiver.CouchRequestReceiver;
import org.tiogasolutions.notify.kernel.receiver.ReceiverExecutorStatus;
import org.tiogasolutions.notify.kernel.receiver.RequestReceiver;
import org.tiogasolutions.notify.pub.domain.DomainProfile;

@Component
public class ReceiverExecutor
implements BeanFactoryAware {
    private static final String NAME = ReceiverExecutor.class.getSimpleName();
    private static final Logger log = LoggerFactory.getLogger(ReceiverExecutor.class);
    private final DomainKernel domainKernel;
    private final List<RequestReceiver> _receivers = new ArrayList<RequestReceiver>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final NotificationKernel notificationKernel;
    private ReceiverExecutorStatus executorStatus = ReceiverExecutorStatus.STOPPED;
    private ScheduledFuture executorFuture = null;
    private BeanFactory beanFactory;

    @Autowired
    public ReceiverExecutor(DomainKernel domainKernel, NotificationKernel notificationKernel) {
        this.domainKernel = domainKernel;
        this.notificationKernel = notificationKernel;
    }

    public ReceiverExecutorStatus getExecutorStatus() {
        return this.executorStatus;
    }

    public synchronized void start() {
        if (this.executorFuture != null) {
            throw new IllegalStateException(NAME + " is already started.");
        }
        this.executorFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this::execute, 5L, 5L, TimeUnit.SECONDS);
        this.executorStatus = ReceiverExecutorStatus.IDLE;
        log.info(NAME + " started, now idle.");
    }

    public synchronized void stop() {
        if (this.executorFuture != null) {
            this.executorFuture.cancel(false);
            this.executorFuture = null;
        }
        this.executorStatus = ReceiverExecutorStatus.STOPPED;
        log.info(NAME + " stopped.");
    }

    @PreDestroy
    private void shutdown() {
        this.stop();
        this.scheduledExecutorService.shutdown();
    }

    public void execute() {
        if (this.running.compareAndSet(false, true)) {
            log.trace("ReceiverExecutor is executing.");
            this.executorStatus = ReceiverExecutorStatus.EXECUTING;
            try {
                this.executeAllDomains();
            }
            catch (Exception e) {
                log.error("Unexpected exception during processing.", (Throwable)e);
            }
            finally {
                this.executorStatus = ReceiverExecutorStatus.IDLE;
                log.trace("ReceiverExecutor finished, now idle.");
                this.running.set(false);
            }
        } else {
            log.debug(NAME + " already running.");
        }
    }

    protected void executeAllDomains() {
        List<DomainProfile> activeProfiles = this.domainKernel.listActiveDomainProfiles();
        activeProfiles.stream().forEach(this::executeAllReceivers);
    }

    public List<RequestReceiver> getReceivers() {
        if (this._receivers.isEmpty()) {
            ExecutionManager executionManager = (ExecutionManager)this.beanFactory.getBean(ExecutionManager.class);
            this._receivers.add(new CouchRequestReceiver(this.domainKernel, this.notificationKernel, executionManager));
        }
        return this._receivers;
    }

    protected void executeAllReceivers(DomainProfile domainProfile) {
        for (RequestReceiver receiver : this.getReceivers()) {
            String receiverName = receiver.getClass().getName();
            String domainName = domainProfile.getDomainName();
            try {
                log.trace("Executing receiver {} for domain {}", (Object)receiverName, (Object)domainName);
                receiver.receiveRequests(domainProfile);
            }
            catch (Throwable t) {
                String msg = String.format("Unexpected exception processing receiver %s for domain %s.", receiverName, domainName);
                log.error(msg, t);
            }
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

