/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.notification.NotificationDomain;
import org.tiogasolutions.notify.kernel.task.CreateTask;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.notifier.Notifier;
import org.tiogasolutions.notify.notifier.send.SendNotificationResponse;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.notification.NotificationRef;
import org.tiogasolutions.notify.pub.route.Destination;

@Component
public class TaskGenerator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Notifier notifier;
    private final EventBus eventBus;
    private final ExecutorService executorService;

    @Autowired
    public TaskGenerator(EventBus eventBus, Notifier notifier) {
        this.notifier = notifier;
        this.eventBus = eventBus;
        this.executorService = Executors.newCachedThreadPool();
    }

    @PreDestroy
    public void dispose() {
        this.executorService.shutdown();
    }

    public Future<List<TaskEntity>> generateTasks(NotificationDomain notificationDomain, Notification notification) {
        return this.executorService.submit(() -> this.createTask(notificationDomain, notification));
    }

    private List<TaskEntity> createTask(NotificationDomain notificationDomain, Notification notification) {
        this.log.info("Generating tasks for notification {}", (Object)notification.getNotificationId());
        ArrayList<TaskEntity> tasks = new ArrayList<TaskEntity>();
        try {
            NotificationRef notificationRef = notification.toNotificationRef();
            Set<Destination> destinations = notificationDomain.findDestinations(notification);
            this.log.info("Found {} destinations", (Object)destinations.size());
            for (Destination destination : destinations) {
                this.createTask(notificationDomain, notification, tasks, notificationRef, destination);
            }
            this.log.info("Created {} tasks.", (Object)tasks.size());
        }
        catch (Exception e) {
            this.notify(notification, e, String.format("Exception generating tasks (notification=%s).", notification.getNotificationId()));
        }
        return tasks;
    }

    private void createTask(NotificationDomain notificationDomain, Notification notification, List<TaskEntity> tasks, NotificationRef notificationRef, Destination destination) {
        try {
            this.log.info("Creating task (notification={}, destination={})", (Object)notification.getNotificationId(), (Object)destination.getName());
            CreateTask create = CreateTask.create(notificationRef, destination);
            TaskEntity task = notificationDomain.createTask(create, notification);
            tasks.add(task);
        }
        catch (Exception e) {
            this.notify(notification, e, String.format("Exception generating task (notification=%s, destination=%s).", notification.getNotificationId(), destination.getName()));
        }
    }

    private void notify(Notification notification, Exception e, String msg) {
        try {
            if (notification != null && notification.isInternalException()) {
                this.log.error("SUPPRESSED: " + msg, (Throwable)e);
            } else {
                SendNotificationResponse sendNotificationResponse = (SendNotificationResponse)this.notifier.begin().summary(msg).exception((Throwable)e).send().get();
            }
        }
        catch (Exception ex) {
            this.log.error("Exception sending notification", (Throwable)ex);
        }
    }
}

