/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tiogasolutions.notify.pub.attachment.AttachmentInfo;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.common.Link;
import org.tiogasolutions.notify.pub.notification.NotificationRef;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Notification
implements Comparable<Notification> {
    private final boolean internal;
    private final URI self;
    private final String domainName;
    private final String notificationId;
    private final String revision;
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final List<Link> links;
    private final ExceptionInfo exceptionInfo;
    private final List<AttachmentInfo> attachmentInfoList;

    @JsonCreator
    public Notification(@JsonProperty(value="internal", defaultValue="false") boolean internal, @JsonProperty(value="self") URI self, @JsonProperty(value="domainName") String domainName, @JsonProperty(value="notificationId") String notificationId, @JsonProperty(value="revision") String revision, @JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="traitMap") Map<String, String> traitMap, @JsonProperty(value="links") List<Link> links, @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo, @JsonProperty(value="attachmentInfoList") List<AttachmentInfo> attachmentInfoList) {
        this.internal = internal;
        this.self = self;
        this.domainName = domainName;
        this.notificationId = notificationId;
        this.revision = revision;
        this.topic = topic;
        this.summary = summary;
        this.trackingId = trackingId;
        this.createdAt = createdAt;
        this.exceptionInfo = exceptionInfo;
        this.traitMap = traitMap == null ? Collections.emptyMap() : Collections.unmodifiableSortedMap(new TreeMap<String, String>(traitMap));
        this.links = links == null ? Collections.emptyList() : Collections.unmodifiableList(links);
        this.attachmentInfoList = attachmentInfoList == null ? Collections.emptyList() : Collections.unmodifiableList(attachmentInfoList);
    }

    public boolean isInternal() {
        return this.internal;
    }

    public NotificationRef toNotificationRef() {
        return new NotificationRef(this.domainName, this.notificationId, this.revision);
    }

    public URI getSelf() {
        return this.self;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getCreatedAtLocal() {
        return this.createdAt.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public boolean hasTrait(String name, String expected) {
        if (name != null && this.traitMap.containsKey(name.toLowerCase())) {
            String value = this.traitMap.get(name);
            if (value == null) {
                return expected == null;
            }
            return value.toLowerCase().equals(expected.toLowerCase());
        }
        return false;
    }

    public boolean hasTrait(String name) {
        return name != null && this.traitMap.containsKey(name.toLowerCase());
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public boolean hasException() {
        return this.exceptionInfo != null;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<AttachmentInfo> getAttachmentInfoList() {
        return this.attachmentInfoList;
    }

    @Override
    public int compareTo(Notification that) {
        int diff = this.createdAt.compareTo(that.createdAt);
        if (diff != 0) {
            return diff;
        }
        return this.notificationId.compareTo(that.notificationId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        if (this.internal != that.internal) {
            return false;
        }
        if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) {
            return false;
        }
        if (this.notificationId != null ? !this.notificationId.equals(that.notificationId) : that.notificationId != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.trackingId != null ? !this.trackingId.equals(that.trackingId) : that.trackingId != null) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.traitMap != null ? !this.traitMap.equals(that.traitMap) : that.traitMap != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.exceptionInfo != null ? !this.exceptionInfo.equals(that.exceptionInfo) : that.exceptionInfo != null) {
            return false;
        }
        return this.attachmentInfoList != null ? this.attachmentInfoList.equals(that.attachmentInfoList) : that.attachmentInfoList == null;
    }

    public int hashCode() {
        int result = this.internal ? 1 : 0;
        result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
        result = 31 * result + (this.notificationId != null ? this.notificationId.hashCode() : 0);
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.trackingId != null ? this.trackingId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.traitMap != null ? this.traitMap.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.exceptionInfo != null ? this.exceptionInfo.hashCode() : 0);
        result = 31 * result + (this.attachmentInfoList != null ? this.attachmentInfoList.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Notification{internal=" + this.internal + ", self=" + this.self + ", domainName='" + this.domainName + '\'' + ", notificationId='" + this.notificationId + '\'' + ", revision='" + this.revision + '\'' + ", topic='" + this.topic + '\'' + ", summary='" + this.summary + '\'' + ", trackingId='" + this.trackingId + '\'' + ", createdAt=" + this.createdAt + ", traitMap=" + this.traitMap + ", links=" + this.links + ", exceptionInfo=" + this.exceptionInfo + ", attachmentInfoList=" + this.attachmentInfoList + '}';
    }

    @JsonIgnore
    public boolean isInternalException() {
        return this.isInternal() && this.hasException();
    }
}

