/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.hal;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tiogasolutions.lib.hal.HalLink;
import org.tiogasolutions.lib.hal.HalLinks;

public class HalLinksBuilder {
    private final LinkedHashMap<String, HalLink> links = new LinkedHashMap();

    public HalLinks build() {
        return new HalLinks((Map<String, HalLink>)this.links);
    }

    public HalLinksBuilder create(String rel, String href) {
        this.links.put(rel, HalLink.create(href));
        return this;
    }

    public HalLinksBuilder create(String rel, URI href) {
        this.links.put(rel, HalLink.create(href));
        return this;
    }

    public HalLinksBuilder create(String rel, String href, String title) {
        this.links.put(rel, HalLink.create(href, title));
        return this;
    }

    public HalLinksBuilder create(String rel, URI href, String title) {
        this.links.put(rel, HalLink.create(href, title));
        return this;
    }

    public HalLinksBuilder add(String rel, HalLink link) {
        this.links.put(rel, link);
        return this;
    }

    public HalLinksBuilder self(HalLink link) {
        this.links.put("self", link);
        return this;
    }

    public HalLinksBuilder first(HalLink link) {
        this.links.put("first", link);
        return this;
    }

    public HalLinksBuilder prev(HalLink link) {
        this.links.put("prev", link);
        return this;
    }

    public HalLinksBuilder next(HalLink link) {
        this.links.put("next", link);
        return this;
    }

    public HalLinksBuilder last(HalLink link) {
        this.links.put("last", link);
        return this;
    }

    public HalLinksBuilder addFPNL(HalLink firstLink, HalLink prevLink, HalLink nextLink, HalLink lastLink) {
        this.first(firstLink);
        this.prev(prevLink);
        this.next(nextLink);
        this.last(lastLink);
        return this;
    }

    public static HalLinksBuilder builder() {
        return new HalLinksBuilder();
    }
}

