/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spring.scope.RequestContextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.notify.NotifyObjectMapper;
import org.tiogasolutions.notify.engine.web.NotifyApplication;
import org.tiogasolutions.notify.engine.web.readers.BundledStaticContentReader;
import org.tiogasolutions.notify.kernel.config.CouchEnvironment;
import org.tiogasolutions.notify.kernel.config.CouchServersConfig;
import org.tiogasolutions.notify.kernel.config.SystemConfiguration;
import org.tiogasolutions.notify.kernel.config.TrustedUserStore;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.task.TaskProcessorExecutor;
import org.tiogasolutions.notify.notifier.Notifier;
import org.tiogasolutions.notify.notifier.send.LoggingNotificationSender;
import org.tiogasolutions.notify.notifier.send.NotificationExceptionInfo;
import org.tiogasolutions.notify.notifier.send.NotificationSender;
import org.tiogasolutions.notify.processor.logger.LoggerTaskProcessor;
import org.tiogasolutions.notify.processor.push.LivePushClientFactory;
import org.tiogasolutions.notify.processor.push.PushTaskProcessor;
import org.tiogasolutions.notify.processor.slack.SlackTaskProcessor;
import org.tiogasolutions.notify.processor.smtp.SmtpTaskProcessor;
import org.tiogasolutions.notify.processor.swing.SwingTaskProcessor;
import org.tiogasolutions.notify.sender.couch.CouchNotificationSender;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;

@Profile(value={"hosted"})
@Configuration
public class NotifyHostedSpringConfig {
    @Bean
    public LivePushClientFactory livePushClientFactory() {
        return new LivePushClientFactory();
    }

    @Bean
    public NotifyObjectMapper notifyObjectMapper() {
        return new NotifyObjectMapper();
    }

    @Bean
    public TiogaJacksonTranslator tiogaJacksonTranslator(NotifyObjectMapper objectMapper) {
        return new TiogaJacksonTranslator((ObjectMapper)objectMapper);
    }

    @Bean
    public TaskProcessorExecutor taskProcessorExecutor(DomainKernel domainKernel, EventBus eventBus, SwingTaskProcessor swingTaskProcessor, LoggerTaskProcessor loggerTaskProcessor, PushTaskProcessor pushTaskProcessor, SlackTaskProcessor slackTaskProcessor, SmtpTaskProcessor smtpTaskProcessor, Notifier notifier) {
        return new TaskProcessorExecutor(domainKernel, eventBus, notifier, Arrays.asList(swingTaskProcessor, loggerTaskProcessor, pushTaskProcessor, slackTaskProcessor, smtpTaskProcessor));
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.SystemConfiguration"})
    public SystemConfiguration systemConfiguration() {
        return new SystemConfiguration("*", false);
    }

    @Bean(name={"org.tiogasolutions.notify.engine.web.readers.ExternalizedStaticContentReader"})
    BundledStaticContentReader bundledStaticContentReader() {
        return new BundledStaticContentReader("/tioga-notifier-engine");
    }

    @Bean(name={"org.tiogasolutions.runners.grizzly.GrizzlyServerConfig"})
    public GrizzlyServerConfig grizzlyServerConfig(@Value(value="${notify_context}") String notifyContext) {
        GrizzlyServerConfig config = new GrizzlyServerConfig();
        config.setHostName(EnvUtils.findProperty((String)"notify_hostName", (String)"0.0.0.0"));
        config.setPort(Integer.valueOf(EnvUtils.findProperty((String)"notify_port", (String)"8080")).intValue());
        config.setShutdownPort(Integer.valueOf(EnvUtils.findProperty((String)"notify_shutdownPort", (String)"8081")).intValue());
        config.setContext(notifyContext);
        config.setToOpenBrowser(false);
        return config;
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.CouchServersConfig"})
    public CouchServersConfig couchServersConfig(@Value(value="${notify_masterUrl}") String masterUrl, @Value(value="${notify_masterUsername}") String masterUsername, @Value(value="${notify_masterPassword}") String masterPassword, @Value(value="${notify_masterDatabaseName}") String masterDatabaseName, @Value(value="${notify_notificationUrl}") String notificationUrl, @Value(value="${notify_notificationUsername}") String notificationUsername, @Value(value="${notify_notificationPassword}") String notificationPassword, @Value(value="${notify_notificationDatabasePrefix}") String notificationDatabasePrefix, @Value(value="${notify_notificationDatabaseSuffix}") String notificationDatabaseSuffix, @Value(value="${notify_requestUrl}") String requestUrl, @Value(value="${notify_requestUsername}") String requestUsername, @Value(value="${notify_requestPassword}") String requestPassword, @Value(value="${notify_requestDatabasePrefix}") String requestDatabasePrefix, @Value(value="${notify_requestDatabaseSuffix}") String requestDatabaseSuffix) {
        CouchServersConfig config = new CouchServersConfig();
        config.setMasterUrl(masterUrl);
        config.setMasterUsername(masterUsername);
        config.setMasterPassword(masterPassword);
        config.setMasterDatabaseName(masterDatabaseName);
        config.setNotificationUrl(notificationUrl);
        config.setNotificationUsername(notificationUsername);
        config.setNotificationPassword(notificationPassword);
        config.setNotificationDatabasePrefix(notificationDatabasePrefix);
        config.setNotificationDatabaseSuffix(notificationDatabaseSuffix);
        config.setRequestUrl(requestUrl);
        config.setRequestUsername(requestUsername);
        config.setRequestPassword(requestPassword);
        config.setRequestDatabasePrefix(requestDatabasePrefix);
        config.setRequestDatabaseSuffix(requestDatabaseSuffix);
        return config;
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.TrustedUserStore"})
    public TrustedUserStore trustedUserStore() {
        return new TrustedUserStore("admin:password");
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.CouchEnvironment"})
    public CouchEnvironment couchEnvironment() {
        return new CouchEnvironment().setTesting(false);
    }

    @Bean
    public NotifyApplication notifyApplication() {
        return new NotifyApplication();
    }

    @Bean
    public GrizzlyServer grizzlyServer(GrizzlyServerConfig grizzlyServerConfig, NotifyApplication application, ApplicationContext applicationContext) {
        ResourceConfig resourceConfig = ResourceConfig.forApplication((Application)application);
        resourceConfig.property("contextConfig", (Object)applicationContext);
        resourceConfig.packages(new String[]{"org.tiogasolutions.notify"});
        resourceConfig.register(RequestContextFilter.class, 1);
        return new GrizzlyServer(grizzlyServerConfig, (Application)resourceConfig);
    }

    @Bean
    public Notifier notifier(@Value(value="${notifier_couch_url}") String couchUrl, @Value(value="${notifier_couch_database_name}") String databaseName, @Value(value="${notifier_couch_username}") String username, @Value(value="${notifier_couch_password}") String password, @Value(value="${notifier_force_logger}") boolean forceLogger) {
        LoggingNotificationSender sender = forceLogger ? new LoggingNotificationSender() : new CouchNotificationSender(couchUrl, databaseName, username, password);
        Logger log = LoggerFactory.getLogger((String)Notifier.class.getSimpleName());
        return new Notifier((NotificationSender)sender).onBegin(builder -> {
            builder.topic("Notify Engine");
            builder.internal();
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                builder.trait("source", (Object)(System.getProperty("user.name") + "@" + hostname));
            }
            catch (UnknownHostException ignored) {
                builder.trait("source", (Object)(System.getProperty("user.name") + "@" + "UNKNOWN"));
            }
        }).onBeforeSend(builder -> log.info("SENDING " + builder.getSummary())).onSuccess(response -> {
            log.info("SUCCESS " + response.getRequest().getSummary());
            NotificationExceptionInfo exceptionInfo = response.getRequest().getExceptionInfo();
            if (exceptionInfo != null) {
                log.error("Trapped exception:\n" + exceptionInfo.getStackTrace());
            }
        }).onFailure(response -> log.error("FAILURE " + response.getRequest().getSummary(), response.getThrowable()));
    }
}

