/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.query;

public class CouchJsonKey {
    private final String jsonValue;

    public CouchJsonKey(Object ... values) {
        this.jsonValue = CouchJsonKey.valuesAsJson(values);
    }

    public String getJsonValue() {
        return this.jsonValue;
    }

    private static String valuesAsJson(Object ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return CouchJsonKey.singleValueAsJson(values[0]);
        }
        StringBuilder sb = new StringBuilder("[");
        for (Object value : values) {
            sb.append(CouchJsonKey.singleValueAsJson(value));
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    private static String singleValueAsJson(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CouchJsonKey) {
            return ((CouchJsonKey)value).getJsonValue();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        return String.format("\"%s\"", value.toString());
    }
}

