/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine;

import java.io.IOException;
import java.net.URL;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.tiogasolutions.notify.engine.AppResource;
import org.tiogasolutions.notify.engine.StaticResources;
import org.tiogasolutions.notify.engine.v2.AdminResourceV2;
import org.tiogasolutions.notify.engine.v2.ClientResourceV2;
import org.tiogasolutions.notify.engine.web.SystemStatus;
import org.tiogasolutions.notify.engine.web.readers.StaticContentReader;
import org.tiogasolutions.notify.kernel.PubUtils;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;

@Path(value="/")
@Scope(value="prototype")
public class RootResource {
    private static final Logger log = LoggerFactory.getLogger(RootResource.class);
    private static final String indexHtml;
    @Context
    UriInfo uriInfo;
    @Autowired
    private ExecutionManager em;
    @Autowired
    private StaticContentReader staticContentReader;
    @Autowired
    private DomainKernel domainKernel;

    public RootResource() {
        log.debug("Created");
    }

    private static Manifest getManifest() throws IOException {
        Enumeration<URL> resources = RootResource.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            try {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                String moduleName = manifest.getMainAttributes().getValue("Module-Name");
                if (!"tioga-notify-server-grizzly".equalsIgnoreCase(moduleName)) continue;
                return manifest;
            }
            catch (IOException iOException) {
            }
        }
        throw new IOException("Manifest not found.");
    }

    @GET
    @Produces(value={"text/html"})
    public String getIndexHtml() throws IOException {
        return this.healthCheck();
    }

    @GET
    @Path(value="/health-check")
    @Produces(value={"text/html"})
    public String healthCheck() {
        return indexHtml;
    }

    @Path(value="/app")
    public AppResource getAppResource() {
        return new AppResource(this.staticContentReader, this.uriInfo);
    }

    @Path(value="/static")
    public StaticResources getIconsResource() {
        return new StaticResources(this.staticContentReader, this.uriInfo);
    }

    @Path(value="/api/v2")
    public ClientResourceV2 getClientResource() {
        return new ClientResourceV2(this.em);
    }

    @Path(value="/api/v2/admin")
    public AdminResourceV2 getAdminResource() {
        return new AdminResourceV2(this.newPubUtils(), this.em, this.domainKernel);
    }

    private PubUtils newPubUtils() {
        return new PubUtils(this.uriInfo);
    }

    @GET
    @Path(value="/api/v2/status")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public SystemStatus getStatus() {
        return new SystemStatus(this.em.getReceiverExecutor().getExecutorStatus(), this.em.getProcessorExecutor().getExecutorStatus());
    }

    @GET
    @Path(value="/manager/status")
    public Response managerStatus() throws Exception {
        return Response.status((int)404).build();
    }

    @GET
    @Path(value="{resource: ([^\\s]+(\\.(?i)(php|PHP))$) }")
    public Response renderTXTs() throws Exception {
        return Response.status((int)404).build();
    }

    @GET
    @Path(value="/favicon.ico")
    public Response favicon_ico() {
        return Response.status((int)404).build();
    }

    @GET
    @Path(value="/trafficbasedsspsitemap.xml")
    public Response trafficbasedsspsitemap_xml() {
        return Response.status((int)404).build();
    }

    @GET
    @Path(value="/apple-touch-icon-precomposed.png")
    public Response apple_touch_icon_precomposed_png() {
        return Response.status((int)404).build();
    }

    @GET
    @Path(value="/apple-touch-icon.png")
    public Response apple_touch_icon_png() {
        return Response.status((int)404).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String html = null;
        String since = ZonedDateTime.now(ZoneId.of(ZoneId.SHORT_IDS.get("PST"))).format(DateTimeFormatter.ofPattern("MMM d, yyyy 'at' h:mm:ss a zzz"));
        try {
            Attributes attributes = RootResource.getManifest().getMainAttributes();
            String version = attributes.getValue("Implementation-Version");
            String build = attributes.getValue("Build-Number");
            String timestamp = attributes.getValue("Build-Timestamp");
            html = String.format("<html><body><h1>Notify Server</h1><div>Build-Number: %s</div><div>Build-Timestamp: %s</div><div>Implementation-Version: %s</div><div>Since: %s</div></body></html>", build, timestamp, version, since);
        }
        catch (Exception e) {
            html = String.format("<html><body><h1>Notify Server</h1><div>Since: %s</div><div>%s</div></body></html>", since, e.getMessage());
        }
        finally {
            indexHtml = html;
        }
    }
}

