/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.notify.engine.web.readers.StaticContentReader;

public class StaticResources {
    private final UriInfo uriInfo;
    private final StaticContentReader staticContentReader;

    public StaticResources(StaticContentReader staticContentReader, UriInfo uriInfo) {
        this.staticContentReader = staticContentReader;
        this.uriInfo = uriInfo;
    }

    @GET
    @Produces(value={"text/html"})
    public byte[] renderAppRoot() {
        return this.staticContentReader.readContent("/static/index.html");
    }

    @GET
    @Produces(value={"image/png"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(png|PNG))$) }")
    public byte[] renderPNGs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"image/gif"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(gif|GIF))$) }")
    public byte[] renderGIFs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(txt|TXT|text|TEXT))$) }")
    public byte[] renderText() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(html|HTML))$) }")
    public byte[] renderHtml() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"text/css"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(css|CSS))$) }")
    public byte[] renderCSS() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"application/javascript"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(js|JS))$) }")
    public byte[] renderJavaScript() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"image/icon"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(ico|ICO))$) }")
    public byte[] renderICOs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"application/pdf"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(pdf|PDF))$) }")
    public byte[] renderPDFs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"application/font-woff"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(otf|OTF))$) }")
    public byte[] renderOTFs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"application/vnd.ms-fontobject"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(eot|EOT))$) }")
    public byte[] renderEOTs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"image/svg+xml"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(svg|SVG))$) }")
    public byte[] renderSVGs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"application/x-font-ttf"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(ttf|TTF))$) }")
    public byte[] renderTTFs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }

    @GET
    @Produces(value={"application/font-woff"})
    @Path(value="{resource: ([^\\s]+(\\.(?i)(woff|WOFF|woff2|WOFF2))$) }")
    public byte[] renderWOFFs() throws Exception {
        return this.staticContentReader.readContent(this.uriInfo);
    }
}

