/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.jobs;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.notification.NotificationDomain;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.notification.NotificationQuery;
import org.tiogasolutions.notify.pub.task.TaskQuery;

public class PruneNotificationsAndTasksJob
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean running = false;
    private long notificationsProcessed = 0L;
    private long tasksProcessed = 0L;
    private final String domainName;
    private final NotificationDomain notificationDomain;

    public PruneNotificationsAndTasksJob(DomainKernel domainKernel, String domainName) {
        this.domainName = domainName;
        this.notificationDomain = domainKernel.notificationDomain(domainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            List notifications = null;
            while (notifications == null || notifications.size() > 0) {
                NotificationQuery noteQuery = new NotificationQuery().setLimit(100);
                notifications = this.notificationDomain.query(noteQuery).getResults();
                this.log.info("Deleting {} notifications for the domain {}.", (Object)notifications.size(), (Object)this.domainName);
                for (Notification notification : notifications) {
                    this.pruneNotification(notification);
                }
            }
            List tasks = null;
            while (tasks == null || tasks.size() > 0) {
                tasks = this.notificationDomain.query(new TaskQuery().setLimit(100)).getResults();
                this.log.info("Deleting {} abandoned tasks for the domain {}.", (Object)tasks.size(), (Object)this.domainName);
                for (TaskEntity task : tasks) {
                    if (!task.getTaskStatus().isCompleted() && !task.getTaskStatus().isFailed()) continue;
                    ++this.tasksProcessed;
                    this.notificationDomain.deleteTask(task.getTaskId());
                }
            }
        }
        catch (Exception e) {
            String msg = String.format("Exception deleting notifications & tasks for the domain %s.", this.domainName);
            this.log.error(msg, (Throwable)e);
        }
        finally {
            this.running = false;
            this.log.info("Finished pruning notifications & tasks for the domain {}.", (Object)this.domainName);
        }
    }

    protected void pruneNotification(Notification notification) {
        TaskQuery taskQuery = new TaskQuery().setNotificationId(notification.getNotificationId());
        List tasks = this.notificationDomain.query(taskQuery).getResults();
        for (TaskEntity task : tasks) {
            if (!task.getTaskStatus().isSending() && !task.getTaskStatus().isPending()) continue;
            this.log.info("Skipping {} tasks given notification {} for the domain {}.", new Object[]{tasks.size(), notification.getNotificationId(), this.domainName});
            return;
        }
        this.log.info("Deleting {} tasks given notification {} for the domain {}.", new Object[]{tasks.size(), notification.getNotificationId(), this.domainName});
        for (TaskEntity task : tasks) {
            ++this.tasksProcessed;
            this.notificationDomain.deleteTask(task.getTaskId());
        }
        ++this.notificationsProcessed;
        this.notificationDomain.deleteNotification(notification.getNotificationId());
    }

    public boolean isRunning() {
        return this.running;
    }

    public Results getStartedResults() {
        return new Results(this.notificationsProcessed, this.tasksProcessed, String.format("STARTED: Deleted %s notifications and %s tasks from the domain %s.", this.notificationsProcessed, this.tasksProcessed, this.domainName));
    }

    public Results getResults() {
        if (this.running) {
            return new Results(this.notificationsProcessed, this.tasksProcessed, String.format("RUNNING: Deleted %s notifications and %s tasks from the domain %s.", this.notificationsProcessed, this.tasksProcessed, this.domainName));
        }
        return new Results(this.notificationsProcessed, this.tasksProcessed, String.format("COMPLETED: Deleted %s notifications and %s tasks from the domain %s.", this.notificationsProcessed, this.tasksProcessed, this.domainName));
    }

    public static class Results {
        private final String message;
        private final long notificationsProcessed;
        private final long tasksProcessed;

        public Results(long notificationsProcessed, long tasksProcessed, String message) {
            this.tasksProcessed = tasksProcessed;
            this.notificationsProcessed = notificationsProcessed;
            this.message = message;
        }

        public long getNotificationsProcessed() {
            return this.notificationsProcessed;
        }

        public long getTasksProcessed() {
            return this.tasksProcessed;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

